<?php

namespace Opsuite\Transaction;

class TransactionBenefit
{

    /**
     * @var string $BenefitKey
     */
    protected $BenefitKey = null;

    /**
     * @var int $BenefitType
     */
    protected $BenefitType = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var int $DiscountReasonCodeId
     */
    protected $DiscountReasonCodeId = null;

    /**
     * @var int $PromotionId
     */
    protected $PromotionId = null;

    /**
     * @var \DateTime $PromotionLastUpdated
     */
    protected $PromotionLastUpdated = null;

    /**
     * @var float $Saving
     */
    protected $Saving = null;

    /**
     * @var int $SequenceNo
     */
    protected $SequenceNo = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getBenefitKey()
    {
      return $this->BenefitKey;
    }

    /**
     * @param string $BenefitKey
     * @return \Opsuite\Transaction\TransactionBenefit
     */
    public function setBenefitKey($BenefitKey)
    {
      $this->BenefitKey = $BenefitKey;
      return $this;
    }

    /**
     * @return int
     */
    public function getBenefitType()
    {
      return $this->BenefitType;
    }

    /**
     * @param int $BenefitType
     * @return \Opsuite\Transaction\TransactionBenefit
     */
    public function setBenefitType($BenefitType)
    {
      $this->BenefitType = $BenefitType;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Transaction\TransactionBenefit
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return int
     */
    public function getDiscountReasonCodeId()
    {
      return $this->DiscountReasonCodeId;
    }

    /**
     * @param int $DiscountReasonCodeId
     * @return \Opsuite\Transaction\TransactionBenefit
     */
    public function setDiscountReasonCodeId($DiscountReasonCodeId)
    {
      $this->DiscountReasonCodeId = $DiscountReasonCodeId;
      return $this;
    }

    /**
     * @return int
     */
    public function getPromotionId()
    {
      return $this->PromotionId;
    }

    /**
     * @param int $PromotionId
     * @return \Opsuite\Transaction\TransactionBenefit
     */
    public function setPromotionId($PromotionId)
    {
      $this->PromotionId = $PromotionId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getPromotionLastUpdated()
    {
      if ($this->PromotionLastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->PromotionLastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $PromotionLastUpdated
     * @return \Opsuite\Transaction\TransactionBenefit
     */
    public function setPromotionLastUpdated(\DateTime $PromotionLastUpdated = null)
    {
      if ($PromotionLastUpdated == null) {
       $this->PromotionLastUpdated = null;
      } else {
        $this->PromotionLastUpdated = $PromotionLastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return float
     */
    public function getSaving()
    {
      return $this->Saving;
    }

    /**
     * @param float $Saving
     * @return \Opsuite\Transaction\TransactionBenefit
     */
    public function setSaving($Saving)
    {
      $this->Saving = $Saving;
      return $this;
    }

    /**
     * @return int
     */
    public function getSequenceNo()
    {
      return $this->SequenceNo;
    }

    /**
     * @param int $SequenceNo
     * @return \Opsuite\Transaction\TransactionBenefit
     */
    public function setSequenceNo($SequenceNo)
    {
      $this->SequenceNo = $SequenceNo;
      return $this;
    }

}
