<?php

namespace Opsuite\Transaction;

class SubmitTransactionResult
{

    /**
     * @var int $BatchNumber
     */
    protected $BatchNumber = null;

    /**
     * @var ArrayOfErrorInfo $Errors
     */
    protected $Errors = null;

    /**
     * @var int $ExternalBatchNumber
     */
    protected $ExternalBatchNumber = null;

    /**
     * @var int $ExternalTransactionNumber
     */
    protected $ExternalTransactionNumber = null;

    /**
     * @var int $TransactionId
     */
    protected $TransactionId = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return int
     */
    public function getBatchNumber()
    {
      return $this->BatchNumber;
    }

    /**
     * @param int $BatchNumber
     * @return \Opsuite\Transaction\SubmitTransactionResult
     */
    public function setBatchNumber($BatchNumber)
    {
      $this->BatchNumber = $BatchNumber;
      return $this;
    }

    /**
     * @return ArrayOfErrorInfo
     */
    public function getErrors()
    {
      return $this->Errors;
    }

    /**
     * @param ArrayOfErrorInfo $Errors
     * @return \Opsuite\Transaction\SubmitTransactionResult
     */
    public function setErrors($Errors)
    {
      $this->Errors = $Errors;
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalBatchNumber()
    {
      return $this->ExternalBatchNumber;
    }

    /**
     * @param int $ExternalBatchNumber
     * @return \Opsuite\Transaction\SubmitTransactionResult
     */
    public function setExternalBatchNumber($ExternalBatchNumber)
    {
      $this->ExternalBatchNumber = $ExternalBatchNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalTransactionNumber()
    {
      return $this->ExternalTransactionNumber;
    }

    /**
     * @param int $ExternalTransactionNumber
     * @return \Opsuite\Transaction\SubmitTransactionResult
     */
    public function setExternalTransactionNumber($ExternalTransactionNumber)
    {
      $this->ExternalTransactionNumber = $ExternalTransactionNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getTransactionId()
    {
      return $this->TransactionId;
    }

    /**
     * @param int $TransactionId
     * @return \Opsuite\Transaction\SubmitTransactionResult
     */
    public function setTransactionId($TransactionId)
    {
      $this->TransactionId = $TransactionId;
      return $this;
    }

}
