<?php

namespace Opsuite\Transaction;

class SubmitTransaction
{

    /**
     * @var RetailTransaction $newTransaction
     */
    protected $newTransaction = null;

    /**
     * @var boolean $calculateTax
     */
    protected $calculateTax = null;

    /**
     * @param RetailTransaction $newTransaction
     * @param boolean $calculateTax
     */
    public function __construct($newTransaction, $calculateTax)
    {
      $this->newTransaction = $newTransaction;
      $this->calculateTax = $calculateTax;
    }

    /**
     * @return RetailTransaction
     */
    public function getNewTransaction()
    {
      return $this->newTransaction;
    }

    /**
     * @param RetailTransaction $newTransaction
     * @return \Opsuite\Transaction\SubmitTransaction
     */
    public function setNewTransaction($newTransaction)
    {
      $this->newTransaction = $newTransaction;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getCalculateTax()
    {
      return $this->calculateTax;
    }

    /**
     * @param boolean $calculateTax
     * @return \Opsuite\Transaction\SubmitTransaction
     */
    public function setCalculateTax($calculateTax)
    {
      $this->calculateTax = $calculateTax;
      return $this;
    }

}
