<?php

namespace Opsuite\Transaction;

class RetailTransactionLineItem
{

    /**
     * @var float $ExtendedPrice
     */
    protected $ExtendedPrice = null;

    /**
     * @var int $Id
     */
    protected $Id = null;

    /**
     * @var ArrayOfTransactionLineBenefit $LineBenefits
     */
    protected $LineBenefits = null;

    /**
     * @var float $Quantity
     */
    protected $Quantity = null;

    /**
     * @var float $SalesTax
     */
    protected $SalesTax = null;

    /**
     * @var string $UniqueCode
     */
    protected $UniqueCode = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return float
     */
    public function getExtendedPrice()
    {
      return $this->ExtendedPrice;
    }

    /**
     * @param float $ExtendedPrice
     * @return \Opsuite\Transaction\RetailTransactionLineItem
     */
    public function setExtendedPrice($ExtendedPrice)
    {
      $this->ExtendedPrice = $ExtendedPrice;
      return $this;
    }

    /**
     * @return int
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param int $Id
     * @return \Opsuite\Transaction\RetailTransactionLineItem
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return ArrayOfTransactionLineBenefit
     */
    public function getLineBenefits()
    {
      return $this->LineBenefits;
    }

    /**
     * @param ArrayOfTransactionLineBenefit $LineBenefits
     * @return \Opsuite\Transaction\RetailTransactionLineItem
     */
    public function setLineBenefits($LineBenefits)
    {
      $this->LineBenefits = $LineBenefits;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
      return $this->Quantity;
    }

    /**
     * @param float $Quantity
     * @return \Opsuite\Transaction\RetailTransactionLineItem
     */
    public function setQuantity($Quantity)
    {
      $this->Quantity = $Quantity;
      return $this;
    }

    /**
     * @return float
     */
    public function getSalesTax()
    {
      return $this->SalesTax;
    }

    /**
     * @param float $SalesTax
     * @return \Opsuite\Transaction\RetailTransactionLineItem
     */
    public function setSalesTax($SalesTax)
    {
      $this->SalesTax = $SalesTax;
      return $this;
    }

    /**
     * @return string
     */
    public function getUniqueCode()
    {
      return $this->UniqueCode;
    }

    /**
     * @param string $UniqueCode
     * @return \Opsuite\Transaction\RetailTransactionLineItem
     */
    public function setUniqueCode($UniqueCode)
    {
      $this->UniqueCode = $UniqueCode;
      return $this;
    }

}
