<?php

namespace Opsuite\Transaction;

class RetailTransaction
{

    /**
     * @var string $CashierNumber
     */
    protected $CashierNumber = null;

    /**
     * @var string $Comment
     */
    protected $Comment = null;

    /**
     * @var string $CustomerAccountNumber
     */
    protected $CustomerAccountNumber = null;

    /**
     * @var int $ExternalBatchNumber
     */
    protected $ExternalBatchNumber = null;

    /**
     * @var int $Id
     */
    protected $Id = null;

    /**
     * @var ArrayOfRetailTransactionLineItem $LineItems
     */
    protected $LineItems = null;

    /**
     * @var string $LocationCode
     */
    protected $LocationCode = null;

    /**
     * @var int $RegisterNumber
     */
    protected $RegisterNumber = null;

    /**
     * @var ArrayOfRetailTransactionTenderLineItem $TenderLineItems
     */
    protected $TenderLineItems = null;

    /**
     * @var ArrayOfTransactionBenefit $TransactionBenefits
     */
    protected $TransactionBenefits = null;

    /**
     * @var int $TransactionNumber
     */
    protected $TransactionNumber = null;

    /**
     * @var string $TransactionReference
     */
    protected $TransactionReference = null;

    /**
     * @var \DateTime $TransactionTime
     */
    protected $TransactionTime = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getCashierNumber()
    {
      return $this->CashierNumber;
    }

    /**
     * @param string $CashierNumber
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setCashierNumber($CashierNumber)
    {
      $this->CashierNumber = $CashierNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getComment()
    {
      return $this->Comment;
    }

    /**
     * @param string $Comment
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setComment($Comment)
    {
      $this->Comment = $Comment;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerAccountNumber()
    {
      return $this->CustomerAccountNumber;
    }

    /**
     * @param string $CustomerAccountNumber
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setCustomerAccountNumber($CustomerAccountNumber)
    {
      $this->CustomerAccountNumber = $CustomerAccountNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalBatchNumber()
    {
      return $this->ExternalBatchNumber;
    }

    /**
     * @param int $ExternalBatchNumber
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setExternalBatchNumber($ExternalBatchNumber)
    {
      $this->ExternalBatchNumber = $ExternalBatchNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param int $Id
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return ArrayOfRetailTransactionLineItem
     */
    public function getLineItems()
    {
      return $this->LineItems;
    }

    /**
     * @param ArrayOfRetailTransactionLineItem $LineItems
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setLineItems($LineItems)
    {
      $this->LineItems = $LineItems;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationCode()
    {
      return $this->LocationCode;
    }

    /**
     * @param string $LocationCode
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setLocationCode($LocationCode)
    {
      $this->LocationCode = $LocationCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getRegisterNumber()
    {
      return $this->RegisterNumber;
    }

    /**
     * @param int $RegisterNumber
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setRegisterNumber($RegisterNumber)
    {
      $this->RegisterNumber = $RegisterNumber;
      return $this;
    }

    /**
     * @return ArrayOfRetailTransactionTenderLineItem
     */
    public function getTenderLineItems()
    {
      return $this->TenderLineItems;
    }

    /**
     * @param ArrayOfRetailTransactionTenderLineItem $TenderLineItems
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setTenderLineItems($TenderLineItems)
    {
      $this->TenderLineItems = $TenderLineItems;
      return $this;
    }

    /**
     * @return ArrayOfTransactionBenefit
     */
    public function getTransactionBenefits()
    {
      return $this->TransactionBenefits;
    }

    /**
     * @param ArrayOfTransactionBenefit $TransactionBenefits
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setTransactionBenefits($TransactionBenefits)
    {
      $this->TransactionBenefits = $TransactionBenefits;
      return $this;
    }

    /**
     * @return int
     */
    public function getTransactionNumber()
    {
      return $this->TransactionNumber;
    }

    /**
     * @param int $TransactionNumber
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setTransactionNumber($TransactionNumber)
    {
      $this->TransactionNumber = $TransactionNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getTransactionReference()
    {
      return $this->TransactionReference;
    }

    /**
     * @param string $TransactionReference
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setTransactionReference($TransactionReference)
    {
      $this->TransactionReference = $TransactionReference;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTransactionTime()
    {
      if ($this->TransactionTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->TransactionTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $TransactionTime
     * @return \Opsuite\Transaction\RetailTransaction
     */
    public function setTransactionTime(\DateTime $TransactionTime = null)
    {
      if ($TransactionTime == null) {
       $this->TransactionTime = null;
      } else {
        $this->TransactionTime = $TransactionTime->format(\DateTime::ATOM);
      }
      return $this;
    }

}
