<?php

namespace Opsuite\Transaction;

class RefundTransactionByTransactionId
{

    /**
     * @var int $transactionId
     */
    protected $transactionId = null;

    /**
     * @var int $reasonCodeId
     */
    protected $reasonCodeId = null;

    /**
     * @var int $refundBatchNumber
     */
    protected $refundBatchNumber = null;

    /**
     * @var int $refundTransactionNumber
     */
    protected $refundTransactionNumber = null;

    /**
     * @var string $refundTransactionReference
     */
    protected $refundTransactionReference = null;

    /**
     * @var string $refundTransactionComment
     */
    protected $refundTransactionComment = null;

    /**
     * @param int $transactionId
     * @param int $reasonCodeId
     * @param int $refundBatchNumber
     * @param int $refundTransactionNumber
     * @param string $refundTransactionReference
     * @param string $refundTransactionComment
     */
    public function __construct($transactionId, $reasonCodeId, $refundBatchNumber, $refundTransactionNumber, $refundTransactionReference, $refundTransactionComment)
    {
      $this->transactionId = $transactionId;
      $this->reasonCodeId = $reasonCodeId;
      $this->refundBatchNumber = $refundBatchNumber;
      $this->refundTransactionNumber = $refundTransactionNumber;
      $this->refundTransactionReference = $refundTransactionReference;
      $this->refundTransactionComment = $refundTransactionComment;
    }

    /**
     * @return int
     */
    public function getTransactionId()
    {
      return $this->transactionId;
    }

    /**
     * @param int $transactionId
     * @return \Opsuite\Transaction\RefundTransactionByTransactionId
     */
    public function setTransactionId($transactionId)
    {
      $this->transactionId = $transactionId;
      return $this;
    }

    /**
     * @return int
     */
    public function getReasonCodeId()
    {
      return $this->reasonCodeId;
    }

    /**
     * @param int $reasonCodeId
     * @return \Opsuite\Transaction\RefundTransactionByTransactionId
     */
    public function setReasonCodeId($reasonCodeId)
    {
      $this->reasonCodeId = $reasonCodeId;
      return $this;
    }

    /**
     * @return int
     */
    public function getRefundBatchNumber()
    {
      return $this->refundBatchNumber;
    }

    /**
     * @param int $refundBatchNumber
     * @return \Opsuite\Transaction\RefundTransactionByTransactionId
     */
    public function setRefundBatchNumber($refundBatchNumber)
    {
      $this->refundBatchNumber = $refundBatchNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getRefundTransactionNumber()
    {
      return $this->refundTransactionNumber;
    }

    /**
     * @param int $refundTransactionNumber
     * @return \Opsuite\Transaction\RefundTransactionByTransactionId
     */
    public function setRefundTransactionNumber($refundTransactionNumber)
    {
      $this->refundTransactionNumber = $refundTransactionNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getRefundTransactionReference()
    {
      return $this->refundTransactionReference;
    }

    /**
     * @param string $refundTransactionReference
     * @return \Opsuite\Transaction\RefundTransactionByTransactionId
     */
    public function setRefundTransactionReference($refundTransactionReference)
    {
      $this->refundTransactionReference = $refundTransactionReference;
      return $this;
    }

    /**
     * @return string
     */
    public function getRefundTransactionComment()
    {
      return $this->refundTransactionComment;
    }

    /**
     * @param string $refundTransactionComment
     * @return \Opsuite\Transaction\RefundTransactionByTransactionId
     */
    public function setRefundTransactionComment($refundTransactionComment)
    {
      $this->refundTransactionComment = $refundTransactionComment;
      return $this;
    }

}
