<?php

namespace Opsuite\Transaction;

class Batch
{

    /**
     * @var ArrayOfBatchTenderAmount $BatchTenderAmounts
     */
    protected $BatchTenderAmounts = null;

    /**
     * @var \DateTime $ClosingTime
     */
    protected $ClosingTime = null;

    /**
     * @var int $ExternalBatchNumber
     */
    protected $ExternalBatchNumber = null;

    /**
     * @var string $LocationCode
     */
    protected $LocationCode = null;

    /**
     * @var \DateTime $OpeningTime
     */
    protected $OpeningTime = null;

    /**
     * @var int $RegisterNumber
     */
    protected $RegisterNumber = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ArrayOfBatchTenderAmount
     */
    public function getBatchTenderAmounts()
    {
      return $this->BatchTenderAmounts;
    }

    /**
     * @param ArrayOfBatchTenderAmount $BatchTenderAmounts
     * @return \Opsuite\Transaction\Batch
     */
    public function setBatchTenderAmounts($BatchTenderAmounts)
    {
      $this->BatchTenderAmounts = $BatchTenderAmounts;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getClosingTime()
    {
      if ($this->ClosingTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ClosingTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ClosingTime
     * @return \Opsuite\Transaction\Batch
     */
    public function setClosingTime(\DateTime $ClosingTime = null)
    {
      if ($ClosingTime == null) {
       $this->ClosingTime = null;
      } else {
        $this->ClosingTime = $ClosingTime->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalBatchNumber()
    {
      return $this->ExternalBatchNumber;
    }

    /**
     * @param int $ExternalBatchNumber
     * @return \Opsuite\Transaction\Batch
     */
    public function setExternalBatchNumber($ExternalBatchNumber)
    {
      $this->ExternalBatchNumber = $ExternalBatchNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationCode()
    {
      return $this->LocationCode;
    }

    /**
     * @param string $LocationCode
     * @return \Opsuite\Transaction\Batch
     */
    public function setLocationCode($LocationCode)
    {
      $this->LocationCode = $LocationCode;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getOpeningTime()
    {
      if ($this->OpeningTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->OpeningTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $OpeningTime
     * @return \Opsuite\Transaction\Batch
     */
    public function setOpeningTime(\DateTime $OpeningTime = null)
    {
      if ($OpeningTime == null) {
       $this->OpeningTime = null;
      } else {
        $this->OpeningTime = $OpeningTime->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getRegisterNumber()
    {
      return $this->RegisterNumber;
    }

    /**
     * @param int $RegisterNumber
     * @return \Opsuite\Transaction\Batch
     */
    public function setRegisterNumber($RegisterNumber)
    {
      $this->RegisterNumber = $RegisterNumber;
      return $this;
    }

}
