<?php

namespace Opsuite\Transaction;

class ArrayOfTransactionLineBenefit implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TransactionLineBenefit[] $TransactionLineBenefit
     */
    protected $TransactionLineBenefit = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return TransactionLineBenefit[]
     */
    public function getTransactionLineBenefit()
    {
      return $this->TransactionLineBenefit;
    }

    /**
     * @param TransactionLineBenefit[] $TransactionLineBenefit
     * @return \Opsuite\Transaction\ArrayOfTransactionLineBenefit
     */
    public function setTransactionLineBenefit(array $TransactionLineBenefit = null)
    {
      $this->TransactionLineBenefit = $TransactionLineBenefit;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->TransactionLineBenefit[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TransactionLineBenefit
     */
    public function offsetGet($offset)
    {
      return $this->TransactionLineBenefit[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TransactionLineBenefit $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->TransactionLineBenefit[] = $value;
      } else {
        $this->TransactionLineBenefit[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->TransactionLineBenefit[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TransactionLineBenefit Return the current element
     */
    public function current()
    {
      return current($this->TransactionLineBenefit);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->TransactionLineBenefit);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->TransactionLineBenefit);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->TransactionLineBenefit);
    }

    /**
     * Countable implementation
     *
     * @return TransactionLineBenefit Return count of elements
     */
    public function count()
    {
      return count($this->TransactionLineBenefit);
    }

}
