<?php

namespace Opsuite\Transaction;

class ArrayOfRetailTransactionTenderLineItem implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var RetailTransactionTenderLineItem[] $RetailTransactionTenderLineItem
     */
    protected $RetailTransactionTenderLineItem = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return RetailTransactionTenderLineItem[]
     */
    public function getRetailTransactionTenderLineItem()
    {
      return $this->RetailTransactionTenderLineItem;
    }

    /**
     * @param RetailTransactionTenderLineItem[] $RetailTransactionTenderLineItem
     * @return \Opsuite\Transaction\ArrayOfRetailTransactionTenderLineItem
     */
    public function setRetailTransactionTenderLineItem(array $RetailTransactionTenderLineItem = null)
    {
      $this->RetailTransactionTenderLineItem = $RetailTransactionTenderLineItem;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->RetailTransactionTenderLineItem[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return RetailTransactionTenderLineItem
     */
    public function offsetGet($offset)
    {
      return $this->RetailTransactionTenderLineItem[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param RetailTransactionTenderLineItem $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->RetailTransactionTenderLineItem[] = $value;
      } else {
        $this->RetailTransactionTenderLineItem[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->RetailTransactionTenderLineItem[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return RetailTransactionTenderLineItem Return the current element
     */
    public function current()
    {
      return current($this->RetailTransactionTenderLineItem);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->RetailTransactionTenderLineItem);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->RetailTransactionTenderLineItem);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->RetailTransactionTenderLineItem);
    }

    /**
     * Countable implementation
     *
     * @return RetailTransactionTenderLineItem Return count of elements
     */
    public function count()
    {
      return count($this->RetailTransactionTenderLineItem);
    }

}
