<?php

namespace Opsuite\Transaction;

class ArrayOfErrorInfo implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ErrorInfo[] $ErrorInfo
     */
    protected $ErrorInfo = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ErrorInfo[]
     */
    public function getErrorInfo()
    {
      return $this->ErrorInfo;
    }

    /**
     * @param ErrorInfo[] $ErrorInfo
     * @return \Opsuite\Transaction\ArrayOfErrorInfo
     */
    public function setErrorInfo(array $ErrorInfo = null)
    {
      $this->ErrorInfo = $ErrorInfo;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ErrorInfo[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ErrorInfo
     */
    public function offsetGet($offset)
    {
      return $this->ErrorInfo[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ErrorInfo $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ErrorInfo[] = $value;
      } else {
        $this->ErrorInfo[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ErrorInfo[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ErrorInfo Return the current element
     */
    public function current()
    {
      return current($this->ErrorInfo);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ErrorInfo);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ErrorInfo);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ErrorInfo);
    }

    /**
     * Countable implementation
     *
     * @return ErrorInfo Return count of elements
     */
    public function count()
    {
      return count($this->ErrorInfo);
    }

}
