<?php

namespace Opsuite\Transaction;

class ArrayOfBatchTenderAmount implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var BatchTenderAmount[] $BatchTenderAmount
     */
    protected $BatchTenderAmount = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return BatchTenderAmount[]
     */
    public function getBatchTenderAmount()
    {
      return $this->BatchTenderAmount;
    }

    /**
     * @param BatchTenderAmount[] $BatchTenderAmount
     * @return \Opsuite\Transaction\ArrayOfBatchTenderAmount
     */
    public function setBatchTenderAmount(array $BatchTenderAmount = null)
    {
      $this->BatchTenderAmount = $BatchTenderAmount;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->BatchTenderAmount[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return BatchTenderAmount
     */
    public function offsetGet($offset)
    {
      return $this->BatchTenderAmount[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param BatchTenderAmount $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->BatchTenderAmount[] = $value;
      } else {
        $this->BatchTenderAmount[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->BatchTenderAmount[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return BatchTenderAmount Return the current element
     */
    public function current()
    {
      return current($this->BatchTenderAmount);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->BatchTenderAmount);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->BatchTenderAmount);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->BatchTenderAmount);
    }

    /**
     * Countable implementation
     *
     * @return BatchTenderAmount Return count of elements
     */
    public function count()
    {
      return count($this->BatchTenderAmount);
    }

}
