<?php

namespace Opsuite\Receiving;

use Opsuite\WSSSoapClient;

class ReceivingService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfKeyValuePairOfintdouble' => 'Opsuite\\Receiving\\ArrayOfKeyValuePairOfintdouble',
      'KeyValuePairOfintdouble' => 'Opsuite\\Receiving\\KeyValuePairOfintdouble',
      'ArrayOfKeyValuePairOfstringdouble' => 'Opsuite\\Receiving\\ArrayOfKeyValuePairOfstringdouble',
      'KeyValuePairOfstringdouble' => 'Opsuite\\Receiving\\KeyValuePairOfstringdouble',
      'ArrayOfExportReceivingDocument' => 'Opsuite\\Receiving\\ArrayOfExportReceivingDocument',
      'ExportReceivingDocument' => 'Opsuite\\Receiving\\ExportReceivingDocument',
      'ArrayOfExportReceivingItem' => 'Opsuite\\Receiving\\ArrayOfExportReceivingItem',
      'ExportReceivingItem' => 'Opsuite\\Receiving\\ExportReceivingItem',
      'DeliveryAdvice' => 'Opsuite\\Receiving\\DeliveryAdvice',
      'DeliveryAdviceBySku' => 'Opsuite\\Receiving\\DeliveryAdviceBySku',
      'ArrayOfstring' => 'Opsuite\\Receiving\\ArrayOfstring',
      'GetReceivingDocuments' => 'Opsuite\\Receiving\\GetReceivingDocuments',
      'GetReceivingDocumentsResponse' => 'Opsuite\\Receiving\\GetReceivingDocumentsResponse',
      'GetReceivingDocumentsByLocationCode' => 'Opsuite\\Receiving\\GetReceivingDocumentsByLocationCode',
      'GetReceivingDocumentsByLocationCodeResponse' => 'Opsuite\\Receiving\\GetReceivingDocumentsByLocationCodeResponse',
      'GetReceivingDocumentsByDate' => 'Opsuite\\Receiving\\GetReceivingDocumentsByDate',
      'GetReceivingDocumentsByDateResponse' => 'Opsuite\\Receiving\\GetReceivingDocumentsByDateResponse',
      'GetReceivingDocumentsByDateAndLocationCode' => 'Opsuite\\Receiving\\GetReceivingDocumentsByDateAndLocationCode',
      'GetReceivingDocumentsByDateAndLocationCodeResponse' => 'Opsuite\\Receiving\\GetReceivingDocumentsByDateAndLocationCodeResponse',
      'GetReceivingDocumentsBySupplierCode' => 'Opsuite\\Receiving\\GetReceivingDocumentsBySupplierCode',
      'GetReceivingDocumentsBySupplierCodeResponse' => 'Opsuite\\Receiving\\GetReceivingDocumentsBySupplierCodeResponse',
      'GetReceivingDocumentsByDateAndSupplierCode' => 'Opsuite\\Receiving\\GetReceivingDocumentsByDateAndSupplierCode',
      'GetReceivingDocumentsByDateAndSupplierCodeResponse' => 'Opsuite\\Receiving\\GetReceivingDocumentsByDateAndSupplierCodeResponse',
      'GetReceivingDocumentsByDateAndLocationAndSupplier' => 'Opsuite\\Receiving\\GetReceivingDocumentsByDateAndLocationAndSupplier',
      'GetReceivingDocumentsByDateAndLocationAndSupplierResponse' => 'Opsuite\\Receiving\\GetReceivingDocumentsByDateAndLocationAndSupplierResponse',
      'GetReceivingDocumentsByOrderToBeReceived' => 'Opsuite\\Receiving\\GetReceivingDocumentsByOrderToBeReceived',
      'GetReceivingDocumentsByOrderToBeReceivedResponse' => 'Opsuite\\Receiving\\GetReceivingDocumentsByOrderToBeReceivedResponse',
      'GetReceivingDocumentsByGRN' => 'Opsuite\\Receiving\\GetReceivingDocumentsByGRN',
      'GetReceivingDocumentsByGRNResponse' => 'Opsuite\\Receiving\\GetReceivingDocumentsByGRNResponse',
      'CreateReceivingDocumentFromPurchaseOrder' => 'Opsuite\\Receiving\\CreateReceivingDocumentFromPurchaseOrder',
      'CreateReceivingDocumentFromPurchaseOrderResponse' => 'Opsuite\\Receiving\\CreateReceivingDocumentFromPurchaseOrderResponse',
      'CreatePurchaseOrderReceivingDocument' => 'Opsuite\\Receiving\\CreatePurchaseOrderReceivingDocument',
      'CreatePurchaseOrderReceivingDocumentResponse' => 'Opsuite\\Receiving\\CreatePurchaseOrderReceivingDocumentResponse',
      'CreateTransferReceivingDocument' => 'Opsuite\\Receiving\\CreateTransferReceivingDocument',
      'CreateTransferReceivingDocumentResponse' => 'Opsuite\\Receiving\\CreateTransferReceivingDocumentResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/ReceivingService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetReceivingDocuments $parameters
     * @return GetReceivingDocumentsResponse
     */
    public function GetReceivingDocuments(GetReceivingDocuments $parameters)
    {
      return $this->__soapCall('GetReceivingDocuments', array($parameters));
    }

    /**
     * @param GetReceivingDocumentsByLocationCode $parameters
     * @return GetReceivingDocumentsByLocationCodeResponse
     */
    public function GetReceivingDocumentsByLocationCode(GetReceivingDocumentsByLocationCode $parameters)
    {
      return $this->__soapCall('GetReceivingDocumentsByLocationCode', array($parameters));
    }

    /**
     * @param GetReceivingDocumentsByDate $parameters
     * @return GetReceivingDocumentsByDateResponse
     */
    public function GetReceivingDocumentsByDate(GetReceivingDocumentsByDate $parameters)
    {
      return $this->__soapCall('GetReceivingDocumentsByDate', array($parameters));
    }

    /**
     * @param GetReceivingDocumentsByDateAndLocationCode $parameters
     * @return GetReceivingDocumentsByDateAndLocationCodeResponse
     */
    public function GetReceivingDocumentsByDateAndLocationCode(GetReceivingDocumentsByDateAndLocationCode $parameters)
    {
      return $this->__soapCall('GetReceivingDocumentsByDateAndLocationCode', array($parameters));
    }

    /**
     * @param GetReceivingDocumentsBySupplierCode $parameters
     * @return GetReceivingDocumentsBySupplierCodeResponse
     */
    public function GetReceivingDocumentsBySupplierCode(GetReceivingDocumentsBySupplierCode $parameters)
    {
      return $this->__soapCall('GetReceivingDocumentsBySupplierCode', array($parameters));
    }

    /**
     * @param GetReceivingDocumentsByDateAndSupplierCode $parameters
     * @return GetReceivingDocumentsByDateAndSupplierCodeResponse
     */
    public function GetReceivingDocumentsByDateAndSupplierCode(GetReceivingDocumentsByDateAndSupplierCode $parameters)
    {
      return $this->__soapCall('GetReceivingDocumentsByDateAndSupplierCode', array($parameters));
    }

    /**
     * @param GetReceivingDocumentsByDateAndLocationAndSupplier $parameters
     * @return GetReceivingDocumentsByDateAndLocationAndSupplierResponse
     */
    public function GetReceivingDocumentsByDateAndLocationAndSupplier(GetReceivingDocumentsByDateAndLocationAndSupplier $parameters)
    {
      return $this->__soapCall('GetReceivingDocumentsByDateAndLocationAndSupplier', array($parameters));
    }

    /**
     * @param GetReceivingDocumentsByOrderToBeReceived $parameters
     * @return GetReceivingDocumentsByOrderToBeReceivedResponse
     */
    public function GetReceivingDocumentsByOrderToBeReceived(GetReceivingDocumentsByOrderToBeReceived $parameters)
    {
      return $this->__soapCall('GetReceivingDocumentsByOrderToBeReceived', array($parameters));
    }

    /**
     * @param GetReceivingDocumentsByGRN $parameters
     * @return GetReceivingDocumentsByGRNResponse
     */
    public function GetReceivingDocumentsByGRN(GetReceivingDocumentsByGRN $parameters)
    {
      return $this->__soapCall('GetReceivingDocumentsByGRN', array($parameters));
    }

    /**
     * @param CreateReceivingDocumentFromPurchaseOrder $parameters
     * @return CreateReceivingDocumentFromPurchaseOrderResponse
     */
    public function CreateReceivingDocumentFromPurchaseOrder(CreateReceivingDocumentFromPurchaseOrder $parameters)
    {
      return $this->__soapCall('CreateReceivingDocumentFromPurchaseOrder', array($parameters));
    }

    /**
     * @param CreatePurchaseOrderReceivingDocument $parameters
     * @return CreatePurchaseOrderReceivingDocumentResponse
     */
    public function CreatePurchaseOrderReceivingDocument(CreatePurchaseOrderReceivingDocument $parameters)
    {
      return $this->__soapCall('CreatePurchaseOrderReceivingDocument', array($parameters));
    }

    /**
     * @param CreateTransferReceivingDocument $parameters
     * @return CreateTransferReceivingDocumentResponse
     */
    public function CreateTransferReceivingDocument(CreateTransferReceivingDocument $parameters)
    {
      return $this->__soapCall('CreateTransferReceivingDocument', array($parameters));
    }

}
