<?php

namespace Opsuite\Receiving;

class GetReceivingDocumentsBySupplierCode
{

    /**
     * @var ArrayOfstring $supplierCodes
     */
    protected $supplierCodes = null;

    /**
     * @var GRNStatus $status
     */
    protected $status = null;

    /**
     * @param ArrayOfstring $supplierCodes
     * @param GRNStatus $status
     */
    public function __construct($supplierCodes, $status)
    {
      $this->supplierCodes = $supplierCodes;
      $this->status = $status;
    }

    /**
     * @return ArrayOfstring
     */
    public function getSupplierCodes()
    {
      return $this->supplierCodes;
    }

    /**
     * @param ArrayOfstring $supplierCodes
     * @return \Opsuite\Receiving\GetReceivingDocumentsBySupplierCode
     */
    public function setSupplierCodes($supplierCodes)
    {
      $this->supplierCodes = $supplierCodes;
      return $this;
    }

    /**
     * @return GRNStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param GRNStatus $status
     * @return \Opsuite\Receiving\GetReceivingDocumentsBySupplierCode
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

}
