<?php

namespace Opsuite\Receiving;

class GetReceivingDocumentsByLocationCode
{

    /**
     * @var ArrayOfstring $locationCodes
     */
    protected $locationCodes = null;

    /**
     * @var GRNStatus $status
     */
    protected $status = null;

    /**
     * @param ArrayOfstring $locationCodes
     * @param GRNStatus $status
     */
    public function __construct($locationCodes, $status)
    {
      $this->locationCodes = $locationCodes;
      $this->status = $status;
    }

    /**
     * @return ArrayOfstring
     */
    public function getLocationCodes()
    {
      return $this->locationCodes;
    }

    /**
     * @param ArrayOfstring $locationCodes
     * @return \Opsuite\Receiving\GetReceivingDocumentsByLocationCode
     */
    public function setLocationCodes($locationCodes)
    {
      $this->locationCodes = $locationCodes;
      return $this;
    }

    /**
     * @return GRNStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param GRNStatus $status
     * @return \Opsuite\Receiving\GetReceivingDocumentsByLocationCode
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

}
