<?php

namespace Opsuite\Receiving;

class GetReceivingDocumentsByDateAndLocationAndSupplier
{

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @var DateFilterType $dateType
     */
    protected $dateType = null;

    /**
     * @var ArrayOfstring $locationCodes
     */
    protected $locationCodes = null;

    /**
     * @var ArrayOfstring $supplierCodes
     */
    protected $supplierCodes = null;

    /**
     * @var GRNStatus $status
     */
    protected $status = null;

    /**
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     * @param DateFilterType $dateType
     * @param ArrayOfstring $locationCodes
     * @param ArrayOfstring $supplierCodes
     * @param GRNStatus $status
     */
    public function __construct(\DateTime $startDate, \DateTime $endDate, $dateType, $locationCodes, $supplierCodes, $status)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      $this->endDate = $endDate->format(\DateTime::ATOM);
      $this->dateType = $dateType;
      $this->locationCodes = $locationCodes;
      $this->supplierCodes = $supplierCodes;
      $this->status = $status;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDateAndLocationAndSupplier
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDateAndLocationAndSupplier
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return DateFilterType
     */
    public function getDateType()
    {
      return $this->dateType;
    }

    /**
     * @param DateFilterType $dateType
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDateAndLocationAndSupplier
     */
    public function setDateType($dateType)
    {
      $this->dateType = $dateType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getLocationCodes()
    {
      return $this->locationCodes;
    }

    /**
     * @param ArrayOfstring $locationCodes
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDateAndLocationAndSupplier
     */
    public function setLocationCodes($locationCodes)
    {
      $this->locationCodes = $locationCodes;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getSupplierCodes()
    {
      return $this->supplierCodes;
    }

    /**
     * @param ArrayOfstring $supplierCodes
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDateAndLocationAndSupplier
     */
    public function setSupplierCodes($supplierCodes)
    {
      $this->supplierCodes = $supplierCodes;
      return $this;
    }

    /**
     * @return GRNStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param GRNStatus $status
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDateAndLocationAndSupplier
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

}
