<?php

namespace Opsuite\Receiving;

class GetReceivingDocumentsByDate
{

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @var DateFilterType $dateType
     */
    protected $dateType = null;

    /**
     * @var GRNStatus $status
     */
    protected $status = null;

    /**
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     * @param DateFilterType $dateType
     * @param GRNStatus $status
     */
    public function __construct(\DateTime $startDate, \DateTime $endDate, $dateType, $status)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      $this->endDate = $endDate->format(\DateTime::ATOM);
      $this->dateType = $dateType;
      $this->status = $status;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDate
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDate
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return DateFilterType
     */
    public function getDateType()
    {
      return $this->dateType;
    }

    /**
     * @param DateFilterType $dateType
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDate
     */
    public function setDateType($dateType)
    {
      $this->dateType = $dateType;
      return $this;
    }

    /**
     * @return GRNStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param GRNStatus $status
     * @return \Opsuite\Receiving\GetReceivingDocumentsByDate
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

}
