<?php

namespace Opsuite\Receiving;

class ExportReceivingItem
{

    /**
     * @var float $AdvisedQty
     */
    protected $AdvisedQty = null;

    /**
     * @var float $Allocation
     */
    protected $Allocation = null;

    /**
     * @var float $Cost
     */
    protected $Cost = null;

    /**
     * @var string $Department
     */
    protected $Department = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var float $ExchangeRate
     */
    protected $ExchangeRate = null;

    /**
     * @var float $ExtendedCost
     */
    protected $ExtendedCost = null;

    /**
     * @var float $ExtendedOrderCost
     */
    protected $ExtendedOrderCost = null;

    /**
     * @var string $GRN_Number
     */
    protected $GRN_Number = null;

    /**
     * @var int $IcdMerchandiseLineItemId
     */
    protected $IcdMerchandiseLineItemId = null;

    /**
     * @var int $InventoryControlDocumentId
     */
    protected $InventoryControlDocumentId = null;

    /**
     * @var int $ItemLocationDetailId
     */
    protected $ItemLocationDetailId = null;

    /**
     * @var int $ItemMasterId
     */
    protected $ItemMasterId = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var string $LocationName
     */
    protected $LocationName = null;

    /**
     * @var float $OrderCost
     */
    protected $OrderCost = null;

    /**
     * @var float $QtyDamaged
     */
    protected $QtyDamaged = null;

    /**
     * @var float $QtyOrdered
     */
    protected $QtyOrdered = null;

    /**
     * @var float $QtyOver
     */
    protected $QtyOver = null;

    /**
     * @var float $QtyReceived
     */
    protected $QtyReceived = null;

    /**
     * @var float $QtyReceivedToDate
     */
    protected $QtyReceivedToDate = null;

    /**
     * @var int $ReceivingDocumentLineItemId
     */
    protected $ReceivingDocumentLineItemId = null;

    /**
     * @var string $ReorderNumber
     */
    protected $ReorderNumber = null;

    /**
     * @var string $StoreSku
     */
    protected $StoreSku = null;

    /**
     * @var float $SupplierCost
     */
    protected $SupplierCost = null;

    /**
     * @var string $Title
     */
    protected $Title = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return float
     */
    public function getAdvisedQty()
    {
      return $this->AdvisedQty;
    }

    /**
     * @param float $AdvisedQty
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setAdvisedQty($AdvisedQty)
    {
      $this->AdvisedQty = $AdvisedQty;
      return $this;
    }

    /**
     * @return float
     */
    public function getAllocation()
    {
      return $this->Allocation;
    }

    /**
     * @param float $Allocation
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setAllocation($Allocation)
    {
      $this->Allocation = $Allocation;
      return $this;
    }

    /**
     * @return float
     */
    public function getCost()
    {
      return $this->Cost;
    }

    /**
     * @param float $Cost
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setCost($Cost)
    {
      $this->Cost = $Cost;
      return $this;
    }

    /**
     * @return string
     */
    public function getDepartment()
    {
      return $this->Department;
    }

    /**
     * @param string $Department
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setDepartment($Department)
    {
      $this->Department = $Department;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return float
     */
    public function getExchangeRate()
    {
      return $this->ExchangeRate;
    }

    /**
     * @param float $ExchangeRate
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setExchangeRate($ExchangeRate)
    {
      $this->ExchangeRate = $ExchangeRate;
      return $this;
    }

    /**
     * @return float
     */
    public function getExtendedCost()
    {
      return $this->ExtendedCost;
    }

    /**
     * @param float $ExtendedCost
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setExtendedCost($ExtendedCost)
    {
      $this->ExtendedCost = $ExtendedCost;
      return $this;
    }

    /**
     * @return float
     */
    public function getExtendedOrderCost()
    {
      return $this->ExtendedOrderCost;
    }

    /**
     * @param float $ExtendedOrderCost
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setExtendedOrderCost($ExtendedOrderCost)
    {
      $this->ExtendedOrderCost = $ExtendedOrderCost;
      return $this;
    }

    /**
     * @return string
     */
    public function getGRN_Number()
    {
      return $this->GRN_Number;
    }

    /**
     * @param string $GRN_Number
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setGRN_Number($GRN_Number)
    {
      $this->GRN_Number = $GRN_Number;
      return $this;
    }

    /**
     * @return int
     */
    public function getIcdMerchandiseLineItemId()
    {
      return $this->IcdMerchandiseLineItemId;
    }

    /**
     * @param int $IcdMerchandiseLineItemId
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setIcdMerchandiseLineItemId($IcdMerchandiseLineItemId)
    {
      $this->IcdMerchandiseLineItemId = $IcdMerchandiseLineItemId;
      return $this;
    }

    /**
     * @return int
     */
    public function getInventoryControlDocumentId()
    {
      return $this->InventoryControlDocumentId;
    }

    /**
     * @param int $InventoryControlDocumentId
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setInventoryControlDocumentId($InventoryControlDocumentId)
    {
      $this->InventoryControlDocumentId = $InventoryControlDocumentId;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemLocationDetailId()
    {
      return $this->ItemLocationDetailId;
    }

    /**
     * @param int $ItemLocationDetailId
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setItemLocationDetailId($ItemLocationDetailId)
    {
      $this->ItemLocationDetailId = $ItemLocationDetailId;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemMasterId()
    {
      return $this->ItemMasterId;
    }

    /**
     * @param int $ItemMasterId
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setItemMasterId($ItemMasterId)
    {
      $this->ItemMasterId = $ItemMasterId;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationName()
    {
      return $this->LocationName;
    }

    /**
     * @param string $LocationName
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setLocationName($LocationName)
    {
      $this->LocationName = $LocationName;
      return $this;
    }

    /**
     * @return float
     */
    public function getOrderCost()
    {
      return $this->OrderCost;
    }

    /**
     * @param float $OrderCost
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setOrderCost($OrderCost)
    {
      $this->OrderCost = $OrderCost;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyDamaged()
    {
      return $this->QtyDamaged;
    }

    /**
     * @param float $QtyDamaged
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setQtyDamaged($QtyDamaged)
    {
      $this->QtyDamaged = $QtyDamaged;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyOrdered()
    {
      return $this->QtyOrdered;
    }

    /**
     * @param float $QtyOrdered
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setQtyOrdered($QtyOrdered)
    {
      $this->QtyOrdered = $QtyOrdered;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyOver()
    {
      return $this->QtyOver;
    }

    /**
     * @param float $QtyOver
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setQtyOver($QtyOver)
    {
      $this->QtyOver = $QtyOver;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyReceived()
    {
      return $this->QtyReceived;
    }

    /**
     * @param float $QtyReceived
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setQtyReceived($QtyReceived)
    {
      $this->QtyReceived = $QtyReceived;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyReceivedToDate()
    {
      return $this->QtyReceivedToDate;
    }

    /**
     * @param float $QtyReceivedToDate
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setQtyReceivedToDate($QtyReceivedToDate)
    {
      $this->QtyReceivedToDate = $QtyReceivedToDate;
      return $this;
    }

    /**
     * @return int
     */
    public function getReceivingDocumentLineItemId()
    {
      return $this->ReceivingDocumentLineItemId;
    }

    /**
     * @param int $ReceivingDocumentLineItemId
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setReceivingDocumentLineItemId($ReceivingDocumentLineItemId)
    {
      $this->ReceivingDocumentLineItemId = $ReceivingDocumentLineItemId;
      return $this;
    }

    /**
     * @return string
     */
    public function getReorderNumber()
    {
      return $this->ReorderNumber;
    }

    /**
     * @param string $ReorderNumber
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setReorderNumber($ReorderNumber)
    {
      $this->ReorderNumber = $ReorderNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getStoreSku()
    {
      return $this->StoreSku;
    }

    /**
     * @param string $StoreSku
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setStoreSku($StoreSku)
    {
      $this->StoreSku = $StoreSku;
      return $this;
    }

    /**
     * @return float
     */
    public function getSupplierCost()
    {
      return $this->SupplierCost;
    }

    /**
     * @param float $SupplierCost
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setSupplierCost($SupplierCost)
    {
      $this->SupplierCost = $SupplierCost;
      return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
      return $this->Title;
    }

    /**
     * @param string $Title
     * @return \Opsuite\Receiving\ExportReceivingItem
     */
    public function setTitle($Title)
    {
      $this->Title = $Title;
      return $this;
    }

}
