<?php

namespace Opsuite\Receiving;

class ExportReceivingDocument
{

    /**
     * @var \DateTime $AdvisedDeliveryDate
     */
    protected $AdvisedDeliveryDate = null;

    /**
     * @var float $AvailableValue
     */
    protected $AvailableValue = null;

    /**
     * @var \DateTime $DateCreated
     */
    protected $DateCreated = null;

    /**
     * @var \DateTime $DateReceived
     */
    protected $DateReceived = null;

    /**
     * @var \DateTime $DateRequired
     */
    protected $DateRequired = null;

    /**
     * @var string $GRN_Number
     */
    protected $GRN_Number = null;

    /**
     * @var int $InventoryControlDocumentId
     */
    protected $InventoryControlDocumentId = null;

    /**
     * @var boolean $IsCorrection
     */
    protected $IsCorrection = null;

    /**
     * @var ArrayOfExportReceivingItem $Items
     */
    protected $Items = null;

    /**
     * @var \DateTime $LastUpdateDate
     */
    protected $LastUpdateDate = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var boolean $Matched
     */
    protected $Matched = null;

    /**
     * @var int $OrderInventoryControlDocumentId
     */
    protected $OrderInventoryControlDocumentId = null;

    /**
     * @var string $OrderNumber
     */
    protected $OrderNumber = null;

    /**
     * @var boolean $Received
     */
    protected $Received = null;

    /**
     * @var int $ReceivingDocumentId
     */
    protected $ReceivingDocumentId = null;

    /**
     * @var string $Status
     */
    protected $Status = null;

    /**
     * @var string $SupplierCode
     */
    protected $SupplierCode = null;

    /**
     * @var string $SupplierCurrencySymbol
     */
    protected $SupplierCurrencySymbol = null;

    /**
     * @var string $Title
     */
    protected $Title = null;

    /**
     * @var float $TotalCost
     */
    protected $TotalCost = null;

    /**
     * @var float $TotalOrderCost
     */
    protected $TotalOrderCost = null;

    /**
     * @var float $TotalSupplierCost
     */
    protected $TotalSupplierCost = null;

    /**
     * @var string $Type
     */
    protected $Type = null;

    /**
     * @var int $UserId
     */
    protected $UserId = null;

    /**
     * @var string $UserName
     */
    protected $UserName = null;

    /**
     * @var int $VendorId
     */
    protected $VendorId = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return \DateTime
     */
    public function getAdvisedDeliveryDate()
    {
      if ($this->AdvisedDeliveryDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->AdvisedDeliveryDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $AdvisedDeliveryDate
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setAdvisedDeliveryDate(\DateTime $AdvisedDeliveryDate = null)
    {
      if ($AdvisedDeliveryDate == null) {
       $this->AdvisedDeliveryDate = null;
      } else {
        $this->AdvisedDeliveryDate = $AdvisedDeliveryDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return float
     */
    public function getAvailableValue()
    {
      return $this->AvailableValue;
    }

    /**
     * @param float $AvailableValue
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setAvailableValue($AvailableValue)
    {
      $this->AvailableValue = $AvailableValue;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
      if ($this->DateCreated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateCreated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateCreated
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setDateCreated(\DateTime $DateCreated = null)
    {
      if ($DateCreated == null) {
       $this->DateCreated = null;
      } else {
        $this->DateCreated = $DateCreated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateReceived()
    {
      if ($this->DateReceived == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateReceived);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateReceived
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setDateReceived(\DateTime $DateReceived = null)
    {
      if ($DateReceived == null) {
       $this->DateReceived = null;
      } else {
        $this->DateReceived = $DateReceived->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateRequired()
    {
      if ($this->DateRequired == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateRequired);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateRequired
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setDateRequired(\DateTime $DateRequired = null)
    {
      if ($DateRequired == null) {
       $this->DateRequired = null;
      } else {
        $this->DateRequired = $DateRequired->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getGRN_Number()
    {
      return $this->GRN_Number;
    }

    /**
     * @param string $GRN_Number
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setGRN_Number($GRN_Number)
    {
      $this->GRN_Number = $GRN_Number;
      return $this;
    }

    /**
     * @return int
     */
    public function getInventoryControlDocumentId()
    {
      return $this->InventoryControlDocumentId;
    }

    /**
     * @param int $InventoryControlDocumentId
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setInventoryControlDocumentId($InventoryControlDocumentId)
    {
      $this->InventoryControlDocumentId = $InventoryControlDocumentId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsCorrection()
    {
      return $this->IsCorrection;
    }

    /**
     * @param boolean $IsCorrection
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setIsCorrection($IsCorrection)
    {
      $this->IsCorrection = $IsCorrection;
      return $this;
    }

    /**
     * @return ArrayOfExportReceivingItem
     */
    public function getItems()
    {
      return $this->Items;
    }

    /**
     * @param ArrayOfExportReceivingItem $Items
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setItems($Items)
    {
      $this->Items = $Items;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdateDate()
    {
      if ($this->LastUpdateDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdateDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdateDate
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setLastUpdateDate(\DateTime $LastUpdateDate = null)
    {
      if ($LastUpdateDate == null) {
       $this->LastUpdateDate = null;
      } else {
        $this->LastUpdateDate = $LastUpdateDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getMatched()
    {
      return $this->Matched;
    }

    /**
     * @param boolean $Matched
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setMatched($Matched)
    {
      $this->Matched = $Matched;
      return $this;
    }

    /**
     * @return int
     */
    public function getOrderInventoryControlDocumentId()
    {
      return $this->OrderInventoryControlDocumentId;
    }

    /**
     * @param int $OrderInventoryControlDocumentId
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setOrderInventoryControlDocumentId($OrderInventoryControlDocumentId)
    {
      $this->OrderInventoryControlDocumentId = $OrderInventoryControlDocumentId;
      return $this;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
      return $this->OrderNumber;
    }

    /**
     * @param string $OrderNumber
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setOrderNumber($OrderNumber)
    {
      $this->OrderNumber = $OrderNumber;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReceived()
    {
      return $this->Received;
    }

    /**
     * @param boolean $Received
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setReceived($Received)
    {
      $this->Received = $Received;
      return $this;
    }

    /**
     * @return int
     */
    public function getReceivingDocumentId()
    {
      return $this->ReceivingDocumentId;
    }

    /**
     * @param int $ReceivingDocumentId
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setReceivingDocumentId($ReceivingDocumentId)
    {
      $this->ReceivingDocumentId = $ReceivingDocumentId;
      return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
      return $this->Status;
    }

    /**
     * @param string $Status
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setStatus($Status)
    {
      $this->Status = $Status;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierCode()
    {
      return $this->SupplierCode;
    }

    /**
     * @param string $SupplierCode
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setSupplierCode($SupplierCode)
    {
      $this->SupplierCode = $SupplierCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierCurrencySymbol()
    {
      return $this->SupplierCurrencySymbol;
    }

    /**
     * @param string $SupplierCurrencySymbol
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setSupplierCurrencySymbol($SupplierCurrencySymbol)
    {
      $this->SupplierCurrencySymbol = $SupplierCurrencySymbol;
      return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
      return $this->Title;
    }

    /**
     * @param string $Title
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setTitle($Title)
    {
      $this->Title = $Title;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalCost()
    {
      return $this->TotalCost;
    }

    /**
     * @param float $TotalCost
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setTotalCost($TotalCost)
    {
      $this->TotalCost = $TotalCost;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalOrderCost()
    {
      return $this->TotalOrderCost;
    }

    /**
     * @param float $TotalOrderCost
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setTotalOrderCost($TotalOrderCost)
    {
      $this->TotalOrderCost = $TotalOrderCost;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalSupplierCost()
    {
      return $this->TotalSupplierCost;
    }

    /**
     * @param float $TotalSupplierCost
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setTotalSupplierCost($TotalSupplierCost)
    {
      $this->TotalSupplierCost = $TotalSupplierCost;
      return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
      return $this->Type;
    }

    /**
     * @param string $Type
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setType($Type)
    {
      $this->Type = $Type;
      return $this;
    }

    /**
     * @return int
     */
    public function getUserId()
    {
      return $this->UserId;
    }

    /**
     * @param int $UserId
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setUserId($UserId)
    {
      $this->UserId = $UserId;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
      return $this->UserName;
    }

    /**
     * @param string $UserName
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setUserName($UserName)
    {
      $this->UserName = $UserName;
      return $this;
    }

    /**
     * @return int
     */
    public function getVendorId()
    {
      return $this->VendorId;
    }

    /**
     * @param int $VendorId
     * @return \Opsuite\Receiving\ExportReceivingDocument
     */
    public function setVendorId($VendorId)
    {
      $this->VendorId = $VendorId;
      return $this;
    }

}
