<?php

namespace Opsuite\Receiving;

class DeliveryAdviceBySku
{

    /**
     * @var \DateTime $AdvisedDeliveryDate
     */
    protected $AdvisedDeliveryDate = null;

    /**
     * @var ArrayOfKeyValuePairOfstringdouble $AdvisedQuantities
     */
    protected $AdvisedQuantities = null;

    /**
     * @var ArrayOfKeyValuePairOfstringdouble $UniqueAdvisedQuantities
     */
    protected $UniqueAdvisedQuantities = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return \DateTime
     */
    public function getAdvisedDeliveryDate()
    {
      if ($this->AdvisedDeliveryDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->AdvisedDeliveryDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $AdvisedDeliveryDate
     * @return \Opsuite\Receiving\DeliveryAdviceBySku
     */
    public function setAdvisedDeliveryDate(\DateTime $AdvisedDeliveryDate = null)
    {
      if ($AdvisedDeliveryDate == null) {
       $this->AdvisedDeliveryDate = null;
      } else {
        $this->AdvisedDeliveryDate = $AdvisedDeliveryDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return ArrayOfKeyValuePairOfstringdouble
     */
    public function getAdvisedQuantities()
    {
      return $this->AdvisedQuantities;
    }

    /**
     * @param ArrayOfKeyValuePairOfstringdouble $AdvisedQuantities
     * @return \Opsuite\Receiving\DeliveryAdviceBySku
     */
    public function setAdvisedQuantities($AdvisedQuantities)
    {
      $this->AdvisedQuantities = $AdvisedQuantities;
      return $this;
    }

    /**
     * @return ArrayOfKeyValuePairOfstringdouble
     */
    public function getUniqueAdvisedQuantities()
    {
      return $this->UniqueAdvisedQuantities;
    }

    /**
     * @param ArrayOfKeyValuePairOfstringdouble $UniqueAdvisedQuantities
     * @return \Opsuite\Receiving\DeliveryAdviceBySku
     */
    public function setUniqueAdvisedQuantities($UniqueAdvisedQuantities)
    {
      $this->UniqueAdvisedQuantities = $UniqueAdvisedQuantities;
      return $this;
    }

}
