<?php

namespace Opsuite\Receiving;

class DeliveryAdvice
{

    /**
     * @var \DateTime $AdvisedDeliveryDate
     */
    protected $AdvisedDeliveryDate = null;

    /**
     * @var ArrayOfKeyValuePairOfintdouble $AdvisedQuantities
     */
    protected $AdvisedQuantities = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return \DateTime
     */
    public function getAdvisedDeliveryDate()
    {
      if ($this->AdvisedDeliveryDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->AdvisedDeliveryDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $AdvisedDeliveryDate
     * @return \Opsuite\Receiving\DeliveryAdvice
     */
    public function setAdvisedDeliveryDate(\DateTime $AdvisedDeliveryDate = null)
    {
      if ($AdvisedDeliveryDate == null) {
       $this->AdvisedDeliveryDate = null;
      } else {
        $this->AdvisedDeliveryDate = $AdvisedDeliveryDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return ArrayOfKeyValuePairOfintdouble
     */
    public function getAdvisedQuantities()
    {
      return $this->AdvisedQuantities;
    }

    /**
     * @param ArrayOfKeyValuePairOfintdouble $AdvisedQuantities
     * @return \Opsuite\Receiving\DeliveryAdvice
     */
    public function setAdvisedQuantities($AdvisedQuantities)
    {
      $this->AdvisedQuantities = $AdvisedQuantities;
      return $this;
    }

}
