<?php

namespace Opsuite\Receiving;

class CreateTransferReceivingDocument
{

    /**
     * @var string $orderNumber
     */
    protected $orderNumber = null;

    /**
     * @var string $title
     */
    protected $title = null;

    /**
     * @var DeliveryAdviceBySku $receivedItems
     */
    protected $receivedItems = null;

    /**
     * @var boolean $issue
     */
    protected $issue = null;

    /**
     * @param string $orderNumber
     * @param string $title
     * @param DeliveryAdviceBySku $receivedItems
     * @param boolean $issue
     */
    public function __construct($orderNumber, $title, $receivedItems, $issue)
    {
      $this->orderNumber = $orderNumber;
      $this->title = $title;
      $this->receivedItems = $receivedItems;
      $this->issue = $issue;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
      return $this->orderNumber;
    }

    /**
     * @param string $orderNumber
     * @return \Opsuite\Receiving\CreateTransferReceivingDocument
     */
    public function setOrderNumber($orderNumber)
    {
      $this->orderNumber = $orderNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
      return $this->title;
    }

    /**
     * @param string $title
     * @return \Opsuite\Receiving\CreateTransferReceivingDocument
     */
    public function setTitle($title)
    {
      $this->title = $title;
      return $this;
    }

    /**
     * @return DeliveryAdviceBySku
     */
    public function getReceivedItems()
    {
      return $this->receivedItems;
    }

    /**
     * @param DeliveryAdviceBySku $receivedItems
     * @return \Opsuite\Receiving\CreateTransferReceivingDocument
     */
    public function setReceivedItems($receivedItems)
    {
      $this->receivedItems = $receivedItems;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIssue()
    {
      return $this->issue;
    }

    /**
     * @param boolean $issue
     * @return \Opsuite\Receiving\CreateTransferReceivingDocument
     */
    public function setIssue($issue)
    {
      $this->issue = $issue;
      return $this;
    }

}
