<?php

namespace Opsuite\Receiving;

class CreateReceivingDocumentFromPurchaseOrder
{

    /**
     * @var string $orderNumber
     */
    protected $orderNumber = null;

    /**
     * @var string $title
     */
    protected $title = null;

    /**
     * @var DeliveryAdvice $supplierAdvice
     */
    protected $supplierAdvice = null;

    /**
     * @param string $orderNumber
     * @param string $title
     * @param DeliveryAdvice $supplierAdvice
     */
    public function __construct($orderNumber, $title, $supplierAdvice)
    {
      $this->orderNumber = $orderNumber;
      $this->title = $title;
      $this->supplierAdvice = $supplierAdvice;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
      return $this->orderNumber;
    }

    /**
     * @param string $orderNumber
     * @return \Opsuite\Receiving\CreateReceivingDocumentFromPurchaseOrder
     */
    public function setOrderNumber($orderNumber)
    {
      $this->orderNumber = $orderNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
      return $this->title;
    }

    /**
     * @param string $title
     * @return \Opsuite\Receiving\CreateReceivingDocumentFromPurchaseOrder
     */
    public function setTitle($title)
    {
      $this->title = $title;
      return $this;
    }

    /**
     * @return DeliveryAdvice
     */
    public function getSupplierAdvice()
    {
      return $this->supplierAdvice;
    }

    /**
     * @param DeliveryAdvice $supplierAdvice
     * @return \Opsuite\Receiving\CreateReceivingDocumentFromPurchaseOrder
     */
    public function setSupplierAdvice($supplierAdvice)
    {
      $this->supplierAdvice = $supplierAdvice;
      return $this;
    }

}
