<?php

namespace Opsuite\Receiving;

class CreatePurchaseOrderReceivingDocument
{

    /**
     * @var string $orderNumber
     */
    protected $orderNumber = null;

    /**
     * @var string $title
     */
    protected $title = null;

    /**
     * @var DeliveryAdviceBySku $receivedItems
     */
    protected $receivedItems = null;

    /**
     * @param string $orderNumber
     * @param string $title
     * @param DeliveryAdviceBySku $receivedItems
     */
    public function __construct($orderNumber, $title, $receivedItems)
    {
      $this->orderNumber = $orderNumber;
      $this->title = $title;
      $this->receivedItems = $receivedItems;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
      return $this->orderNumber;
    }

    /**
     * @param string $orderNumber
     * @return \Opsuite\Receiving\CreatePurchaseOrderReceivingDocument
     */
    public function setOrderNumber($orderNumber)
    {
      $this->orderNumber = $orderNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
      return $this->title;
    }

    /**
     * @param string $title
     * @return \Opsuite\Receiving\CreatePurchaseOrderReceivingDocument
     */
    public function setTitle($title)
    {
      $this->title = $title;
      return $this;
    }

    /**
     * @return DeliveryAdviceBySku
     */
    public function getReceivedItems()
    {
      return $this->receivedItems;
    }

    /**
     * @param DeliveryAdviceBySku $receivedItems
     * @return \Opsuite\Receiving\CreatePurchaseOrderReceivingDocument
     */
    public function setReceivedItems($receivedItems)
    {
      $this->receivedItems = $receivedItems;
      return $this;
    }

}
