<?php

namespace Opsuite\Receiving;

class ArrayOfExportReceivingItem implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportReceivingItem[] $ExportReceivingItem
     */
    protected $ExportReceivingItem = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportReceivingItem[]
     */
    public function getExportReceivingItem()
    {
      return $this->ExportReceivingItem;
    }

    /**
     * @param ExportReceivingItem[] $ExportReceivingItem
     * @return \Opsuite\Receiving\ArrayOfExportReceivingItem
     */
    public function setExportReceivingItem(array $ExportReceivingItem = null)
    {
      $this->ExportReceivingItem = $ExportReceivingItem;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportReceivingItem[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportReceivingItem
     */
    public function offsetGet($offset)
    {
      return $this->ExportReceivingItem[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportReceivingItem $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportReceivingItem[] = $value;
      } else {
        $this->ExportReceivingItem[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportReceivingItem[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportReceivingItem Return the current element
     */
    public function current()
    {
      return current($this->ExportReceivingItem);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportReceivingItem);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportReceivingItem);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportReceivingItem);
    }

    /**
     * Countable implementation
     *
     * @return ExportReceivingItem Return count of elements
     */
    public function count()
    {
      return count($this->ExportReceivingItem);
    }

}
