<?php

namespace Opsuite\Receiving;

class ArrayOfExportReceivingDocument implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExportReceivingDocument[] $ExportReceivingDocument
     */
    protected $ExportReceivingDocument = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExportReceivingDocument[]
     */
    public function getExportReceivingDocument()
    {
      return $this->ExportReceivingDocument;
    }

    /**
     * @param ExportReceivingDocument[] $ExportReceivingDocument
     * @return \Opsuite\Receiving\ArrayOfExportReceivingDocument
     */
    public function setExportReceivingDocument(array $ExportReceivingDocument = null)
    {
      $this->ExportReceivingDocument = $ExportReceivingDocument;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExportReceivingDocument[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExportReceivingDocument
     */
    public function offsetGet($offset)
    {
      return $this->ExportReceivingDocument[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExportReceivingDocument $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExportReceivingDocument[] = $value;
      } else {
        $this->ExportReceivingDocument[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExportReceivingDocument[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExportReceivingDocument Return the current element
     */
    public function current()
    {
      return current($this->ExportReceivingDocument);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExportReceivingDocument);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExportReceivingDocument);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExportReceivingDocument);
    }

    /**
     * Countable implementation
     *
     * @return ExportReceivingDocument Return count of elements
     */
    public function count()
    {
      return count($this->ExportReceivingDocument);
    }

}
