<?php

namespace Opsuite\PurchaseOrder;

use Opsuite\WSSSoapClient;

class PurchaseOrderService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfExportPurchaseOrder' => 'Opsuite\\PurchaseOrder\\ArrayOfExportPurchaseOrder',
      'ExportPurchaseOrder' => 'Opsuite\\PurchaseOrder\\ExportPurchaseOrder',
      'ArrayOfExportPurchaseOrderItem' => 'Opsuite\\PurchaseOrder\\ArrayOfExportPurchaseOrderItem',
      'ExportPurchaseOrderItem' => 'Opsuite\\PurchaseOrder\\ExportPurchaseOrderItem',
      'ArrayOfstring' => 'Opsuite\\PurchaseOrder\\ArrayOfstring',
      'GetPurchaseOrders' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrders',
      'GetPurchaseOrdersResponse' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersResponse',
      'GetPurchaseOrdersByLocationCode' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByLocationCode',
      'GetPurchaseOrdersByLocationCodeResponse' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByLocationCodeResponse',
      'GetPurchaseOrdersByDate' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByDate',
      'GetPurchaseOrdersByDateResponse' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByDateResponse',
      'GetPurchaseOrdersByDateAndLocationCode' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByDateAndLocationCode',
      'GetPurchaseOrdersByDateAndLocationCodeResponse' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByDateAndLocationCodeResponse',
      'GetPurchaseOrdersBySupplierCode' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersBySupplierCode',
      'GetPurchaseOrdersBySupplierCodeResponse' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersBySupplierCodeResponse',
      'GetPurchaseOrdersByDateAndSupplierCode' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByDateAndSupplierCode',
      'GetPurchaseOrdersByDateAndSupplierCodeResponse' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByDateAndSupplierCodeResponse',
      'GetPurchaseOrdersByDateAndLocationAndSupplier' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByDateAndLocationAndSupplier',
      'GetPurchaseOrdersByDateAndLocationAndSupplierResponse' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByDateAndLocationAndSupplierResponse',
      'GetPurchaseOrdersByOrderNumber' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByOrderNumber',
      'GetPurchaseOrdersByOrderNumberResponse' => 'Opsuite\\PurchaseOrder\\GetPurchaseOrdersByOrderNumberResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/PurchaseOrderService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetPurchaseOrders $parameters
     * @return GetPurchaseOrdersResponse
     */
    public function GetPurchaseOrders(GetPurchaseOrders $parameters)
    {
      return $this->__soapCall('GetPurchaseOrders', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByLocationCode $parameters
     * @return GetPurchaseOrdersByLocationCodeResponse
     */
    public function GetPurchaseOrdersByLocationCode(GetPurchaseOrdersByLocationCode $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByLocationCode', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByDate $parameters
     * @return GetPurchaseOrdersByDateResponse
     */
    public function GetPurchaseOrdersByDate(GetPurchaseOrdersByDate $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByDate', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByDateAndLocationCode $parameters
     * @return GetPurchaseOrdersByDateAndLocationCodeResponse
     */
    public function GetPurchaseOrdersByDateAndLocationCode(GetPurchaseOrdersByDateAndLocationCode $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByDateAndLocationCode', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersBySupplierCode $parameters
     * @return GetPurchaseOrdersBySupplierCodeResponse
     */
    public function GetPurchaseOrdersBySupplierCode(GetPurchaseOrdersBySupplierCode $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersBySupplierCode', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByDateAndSupplierCode $parameters
     * @return GetPurchaseOrdersByDateAndSupplierCodeResponse
     */
    public function GetPurchaseOrdersByDateAndSupplierCode(GetPurchaseOrdersByDateAndSupplierCode $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByDateAndSupplierCode', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByDateAndLocationAndSupplier $parameters
     * @return GetPurchaseOrdersByDateAndLocationAndSupplierResponse
     */
    public function GetPurchaseOrdersByDateAndLocationAndSupplier(GetPurchaseOrdersByDateAndLocationAndSupplier $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByDateAndLocationAndSupplier', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByOrderNumber $parameters
     * @return GetPurchaseOrdersByOrderNumberResponse
     */
    public function GetPurchaseOrdersByOrderNumber(GetPurchaseOrdersByOrderNumber $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByOrderNumber', array($parameters));
    }

}
