<?php

namespace Opsuite\PurchaseOrder;

class GetPurchaseOrdersBySupplierCode
{

    /**
     * @var ArrayOfstring $supplierCodes
     */
    protected $supplierCodes = null;

    /**
     * @var POStatus $status
     */
    protected $status = null;

    /**
     * @param ArrayOfstring $supplierCodes
     * @param POStatus $status
     */
    public function __construct($supplierCodes, $status)
    {
      $this->supplierCodes = $supplierCodes;
      $this->status = $status;
    }

    /**
     * @return ArrayOfstring
     */
    public function getSupplierCodes()
    {
      return $this->supplierCodes;
    }

    /**
     * @param ArrayOfstring $supplierCodes
     * @return \Opsuite\PurchaseOrder\GetPurchaseOrdersBySupplierCode
     */
    public function setSupplierCodes($supplierCodes)
    {
      $this->supplierCodes = $supplierCodes;
      return $this;
    }

    /**
     * @return POStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param POStatus $status
     * @return \Opsuite\PurchaseOrder\GetPurchaseOrdersBySupplierCode
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

}
