<?php

namespace Opsuite\PurchaseOrder;

class GetPurchaseOrdersByLocationCode
{

    /**
     * @var ArrayOfstring $locationCodes
     */
    protected $locationCodes = null;

    /**
     * @var POStatus $status
     */
    protected $status = null;

    /**
     * @param ArrayOfstring $locationCodes
     * @param POStatus $status
     */
    public function __construct($locationCodes, $status)
    {
      $this->locationCodes = $locationCodes;
      $this->status = $status;
    }

    /**
     * @return ArrayOfstring
     */
    public function getLocationCodes()
    {
      return $this->locationCodes;
    }

    /**
     * @param ArrayOfstring $locationCodes
     * @return \Opsuite\PurchaseOrder\GetPurchaseOrdersByLocationCode
     */
    public function setLocationCodes($locationCodes)
    {
      $this->locationCodes = $locationCodes;
      return $this;
    }

    /**
     * @return POStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param POStatus $status
     * @return \Opsuite\PurchaseOrder\GetPurchaseOrdersByLocationCode
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

}
