<?php

namespace Opsuite\PurchaseOrder;

class ExportPurchaseOrderItem
{

    /**
     * @var string $BarcodNumber
     */
    protected $BarcodNumber = null;

    /**
     * @var float $Cost
     */
    protected $Cost = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var float $ExtendedCost
     */
    protected $ExtendedCost = null;

    /**
     * @var int $Id
     */
    protected $Id = null;

    /**
     * @var int $ItemId
     */
    protected $ItemId = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var string $LocationName
     */
    protected $LocationName = null;

    /**
     * @var float $MasterPackQuantity
     */
    protected $MasterPackQuantity = null;

    /**
     * @var float $MaxRestock
     */
    protected $MaxRestock = null;

    /**
     * @var float $MinReorder
     */
    protected $MinReorder = null;

    /**
     * @var float $MinimumOrder
     */
    protected $MinimumOrder = null;

    /**
     * @var string $OrderNumber
     */
    protected $OrderNumber = null;

    /**
     * @var float $QuantityAvailable
     */
    protected $QuantityAvailable = null;

    /**
     * @var float $QuantityCommitted
     */
    protected $QuantityCommitted = null;

    /**
     * @var float $QuantityOnHand
     */
    protected $QuantityOnHand = null;

    /**
     * @var float $QuantityOnOrder
     */
    protected $QuantityOnOrder = null;

    /**
     * @var float $QuantityOrdered
     */
    protected $QuantityOrdered = null;

    /**
     * @var float $QuantityReceivedToDate
     */
    protected $QuantityReceivedToDate = null;

    /**
     * @var string $ReorderNumber
     */
    protected $ReorderNumber = null;

    /**
     * @var string $StoreSku
     */
    protected $StoreSku = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getBarcodNumber()
    {
      return $this->BarcodNumber;
    }

    /**
     * @param string $BarcodNumber
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setBarcodNumber($BarcodNumber)
    {
      $this->BarcodNumber = $BarcodNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getCost()
    {
      return $this->Cost;
    }

    /**
     * @param float $Cost
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setCost($Cost)
    {
      $this->Cost = $Cost;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return float
     */
    public function getExtendedCost()
    {
      return $this->ExtendedCost;
    }

    /**
     * @param float $ExtendedCost
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setExtendedCost($ExtendedCost)
    {
      $this->ExtendedCost = $ExtendedCost;
      return $this;
    }

    /**
     * @return int
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param int $Id
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemId()
    {
      return $this->ItemId;
    }

    /**
     * @param int $ItemId
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setItemId($ItemId)
    {
      $this->ItemId = $ItemId;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationName()
    {
      return $this->LocationName;
    }

    /**
     * @param string $LocationName
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setLocationName($LocationName)
    {
      $this->LocationName = $LocationName;
      return $this;
    }

    /**
     * @return float
     */
    public function getMasterPackQuantity()
    {
      return $this->MasterPackQuantity;
    }

    /**
     * @param float $MasterPackQuantity
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setMasterPackQuantity($MasterPackQuantity)
    {
      $this->MasterPackQuantity = $MasterPackQuantity;
      return $this;
    }

    /**
     * @return float
     */
    public function getMaxRestock()
    {
      return $this->MaxRestock;
    }

    /**
     * @param float $MaxRestock
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setMaxRestock($MaxRestock)
    {
      $this->MaxRestock = $MaxRestock;
      return $this;
    }

    /**
     * @return float
     */
    public function getMinReorder()
    {
      return $this->MinReorder;
    }

    /**
     * @param float $MinReorder
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setMinReorder($MinReorder)
    {
      $this->MinReorder = $MinReorder;
      return $this;
    }

    /**
     * @return float
     */
    public function getMinimumOrder()
    {
      return $this->MinimumOrder;
    }

    /**
     * @param float $MinimumOrder
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setMinimumOrder($MinimumOrder)
    {
      $this->MinimumOrder = $MinimumOrder;
      return $this;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
      return $this->OrderNumber;
    }

    /**
     * @param string $OrderNumber
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setOrderNumber($OrderNumber)
    {
      $this->OrderNumber = $OrderNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantityAvailable()
    {
      return $this->QuantityAvailable;
    }

    /**
     * @param float $QuantityAvailable
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setQuantityAvailable($QuantityAvailable)
    {
      $this->QuantityAvailable = $QuantityAvailable;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantityCommitted()
    {
      return $this->QuantityCommitted;
    }

    /**
     * @param float $QuantityCommitted
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setQuantityCommitted($QuantityCommitted)
    {
      $this->QuantityCommitted = $QuantityCommitted;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantityOnHand()
    {
      return $this->QuantityOnHand;
    }

    /**
     * @param float $QuantityOnHand
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setQuantityOnHand($QuantityOnHand)
    {
      $this->QuantityOnHand = $QuantityOnHand;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantityOnOrder()
    {
      return $this->QuantityOnOrder;
    }

    /**
     * @param float $QuantityOnOrder
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setQuantityOnOrder($QuantityOnOrder)
    {
      $this->QuantityOnOrder = $QuantityOnOrder;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantityOrdered()
    {
      return $this->QuantityOrdered;
    }

    /**
     * @param float $QuantityOrdered
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setQuantityOrdered($QuantityOrdered)
    {
      $this->QuantityOrdered = $QuantityOrdered;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantityReceivedToDate()
    {
      return $this->QuantityReceivedToDate;
    }

    /**
     * @param float $QuantityReceivedToDate
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setQuantityReceivedToDate($QuantityReceivedToDate)
    {
      $this->QuantityReceivedToDate = $QuantityReceivedToDate;
      return $this;
    }

    /**
     * @return string
     */
    public function getReorderNumber()
    {
      return $this->ReorderNumber;
    }

    /**
     * @param string $ReorderNumber
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setReorderNumber($ReorderNumber)
    {
      $this->ReorderNumber = $ReorderNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getStoreSku()
    {
      return $this->StoreSku;
    }

    /**
     * @param string $StoreSku
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrderItem
     */
    public function setStoreSku($StoreSku)
    {
      $this->StoreSku = $StoreSku;
      return $this;
    }

}
