<?php

namespace Opsuite\PurchaseOrder;

class ExportPurchaseOrder
{

    /**
     * @var string $ConfirmingTo
     */
    protected $ConfirmingTo = null;

    /**
     * @var \DateTime $DateCreated
     */
    protected $DateCreated = null;

    /**
     * @var \DateTime $DatePlaced
     */
    protected $DatePlaced = null;

    /**
     * @var \DateTime $DateRequired
     */
    protected $DateRequired = null;

    /**
     * @var string $FOBPoint
     */
    protected $FOBPoint = null;

    /**
     * @var string $Freight
     */
    protected $Freight = null;

    /**
     * @var int $InventoryControlDocumentId
     */
    protected $InventoryControlDocumentId = null;

    /**
     * @var ArrayOfExportPurchaseOrderItem $Items
     */
    protected $Items = null;

    /**
     * @var \DateTime $LastUpdateDate
     */
    protected $LastUpdateDate = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var float $OrderCost
     */
    protected $OrderCost = null;

    /**
     * @var string $OrderNumber
     */
    protected $OrderNumber = null;

    /**
     * @var float $OrderShipping
     */
    protected $OrderShipping = null;

    /**
     * @var float $OrderTax
     */
    protected $OrderTax = null;

    /**
     * @var float $OrderTotal
     */
    protected $OrderTotal = null;

    /**
     * @var boolean $Placed
     */
    protected $Placed = null;

    /**
     * @var string $Remarks
     */
    protected $Remarks = null;

    /**
     * @var string $Requisitioner
     */
    protected $Requisitioner = null;

    /**
     * @var string $ShipToLocation
     */
    protected $ShipToLocation = null;

    /**
     * @var string $ShipVia
     */
    protected $ShipVia = null;

    /**
     * @var string $Status
     */
    protected $Status = null;

    /**
     * @var int $StatusId
     */
    protected $StatusId = null;

    /**
     * @var string $Supplier
     */
    protected $Supplier = null;

    /**
     * @var float $TaxRate
     */
    protected $TaxRate = null;

    /**
     * @var string $Terms
     */
    protected $Terms = null;

    /**
     * @var string $Title
     */
    protected $Title = null;

    /**
     * @var int $VendorId
     */
    protected $VendorId = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getConfirmingTo()
    {
      return $this->ConfirmingTo;
    }

    /**
     * @param string $ConfirmingTo
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setConfirmingTo($ConfirmingTo)
    {
      $this->ConfirmingTo = $ConfirmingTo;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
      if ($this->DateCreated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateCreated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateCreated
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setDateCreated(\DateTime $DateCreated = null)
    {
      if ($DateCreated == null) {
       $this->DateCreated = null;
      } else {
        $this->DateCreated = $DateCreated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDatePlaced()
    {
      if ($this->DatePlaced == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DatePlaced);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DatePlaced
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setDatePlaced(\DateTime $DatePlaced = null)
    {
      if ($DatePlaced == null) {
       $this->DatePlaced = null;
      } else {
        $this->DatePlaced = $DatePlaced->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateRequired()
    {
      if ($this->DateRequired == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateRequired);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateRequired
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setDateRequired(\DateTime $DateRequired = null)
    {
      if ($DateRequired == null) {
       $this->DateRequired = null;
      } else {
        $this->DateRequired = $DateRequired->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getFOBPoint()
    {
      return $this->FOBPoint;
    }

    /**
     * @param string $FOBPoint
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setFOBPoint($FOBPoint)
    {
      $this->FOBPoint = $FOBPoint;
      return $this;
    }

    /**
     * @return string
     */
    public function getFreight()
    {
      return $this->Freight;
    }

    /**
     * @param string $Freight
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setFreight($Freight)
    {
      $this->Freight = $Freight;
      return $this;
    }

    /**
     * @return int
     */
    public function getInventoryControlDocumentId()
    {
      return $this->InventoryControlDocumentId;
    }

    /**
     * @param int $InventoryControlDocumentId
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setInventoryControlDocumentId($InventoryControlDocumentId)
    {
      $this->InventoryControlDocumentId = $InventoryControlDocumentId;
      return $this;
    }

    /**
     * @return ArrayOfExportPurchaseOrderItem
     */
    public function getItems()
    {
      return $this->Items;
    }

    /**
     * @param ArrayOfExportPurchaseOrderItem $Items
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setItems($Items)
    {
      $this->Items = $Items;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdateDate()
    {
      if ($this->LastUpdateDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdateDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdateDate
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setLastUpdateDate(\DateTime $LastUpdateDate = null)
    {
      if ($LastUpdateDate == null) {
       $this->LastUpdateDate = null;
      } else {
        $this->LastUpdateDate = $LastUpdateDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return float
     */
    public function getOrderCost()
    {
      return $this->OrderCost;
    }

    /**
     * @param float $OrderCost
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setOrderCost($OrderCost)
    {
      $this->OrderCost = $OrderCost;
      return $this;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
      return $this->OrderNumber;
    }

    /**
     * @param string $OrderNumber
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setOrderNumber($OrderNumber)
    {
      $this->OrderNumber = $OrderNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getOrderShipping()
    {
      return $this->OrderShipping;
    }

    /**
     * @param float $OrderShipping
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setOrderShipping($OrderShipping)
    {
      $this->OrderShipping = $OrderShipping;
      return $this;
    }

    /**
     * @return float
     */
    public function getOrderTax()
    {
      return $this->OrderTax;
    }

    /**
     * @param float $OrderTax
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setOrderTax($OrderTax)
    {
      $this->OrderTax = $OrderTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getOrderTotal()
    {
      return $this->OrderTotal;
    }

    /**
     * @param float $OrderTotal
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setOrderTotal($OrderTotal)
    {
      $this->OrderTotal = $OrderTotal;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getPlaced()
    {
      return $this->Placed;
    }

    /**
     * @param boolean $Placed
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setPlaced($Placed)
    {
      $this->Placed = $Placed;
      return $this;
    }

    /**
     * @return string
     */
    public function getRemarks()
    {
      return $this->Remarks;
    }

    /**
     * @param string $Remarks
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setRemarks($Remarks)
    {
      $this->Remarks = $Remarks;
      return $this;
    }

    /**
     * @return string
     */
    public function getRequisitioner()
    {
      return $this->Requisitioner;
    }

    /**
     * @param string $Requisitioner
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setRequisitioner($Requisitioner)
    {
      $this->Requisitioner = $Requisitioner;
      return $this;
    }

    /**
     * @return string
     */
    public function getShipToLocation()
    {
      return $this->ShipToLocation;
    }

    /**
     * @param string $ShipToLocation
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setShipToLocation($ShipToLocation)
    {
      $this->ShipToLocation = $ShipToLocation;
      return $this;
    }

    /**
     * @return string
     */
    public function getShipVia()
    {
      return $this->ShipVia;
    }

    /**
     * @param string $ShipVia
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setShipVia($ShipVia)
    {
      $this->ShipVia = $ShipVia;
      return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
      return $this->Status;
    }

    /**
     * @param string $Status
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setStatus($Status)
    {
      $this->Status = $Status;
      return $this;
    }

    /**
     * @return int
     */
    public function getStatusId()
    {
      return $this->StatusId;
    }

    /**
     * @param int $StatusId
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setStatusId($StatusId)
    {
      $this->StatusId = $StatusId;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplier()
    {
      return $this->Supplier;
    }

    /**
     * @param string $Supplier
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setSupplier($Supplier)
    {
      $this->Supplier = $Supplier;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxRate()
    {
      return $this->TaxRate;
    }

    /**
     * @param float $TaxRate
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setTaxRate($TaxRate)
    {
      $this->TaxRate = $TaxRate;
      return $this;
    }

    /**
     * @return string
     */
    public function getTerms()
    {
      return $this->Terms;
    }

    /**
     * @param string $Terms
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setTerms($Terms)
    {
      $this->Terms = $Terms;
      return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
      return $this->Title;
    }

    /**
     * @param string $Title
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setTitle($Title)
    {
      $this->Title = $Title;
      return $this;
    }

    /**
     * @return int
     */
    public function getVendorId()
    {
      return $this->VendorId;
    }

    /**
     * @param int $VendorId
     * @return \Opsuite\PurchaseOrder\ExportPurchaseOrder
     */
    public function setVendorId($VendorId)
    {
      $this->VendorId = $VendorId;
      return $this;
    }

}
