<?php

namespace Opsuite\Promotion;

use Opsuite\WSSSoapClient;

class PromotionService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfErrorInfo' => 'Opsuite\\Promotion\\ArrayOfErrorInfo',
      'ErrorInfo' => 'Opsuite\\Promotion\\ErrorInfo',
      'ResultBase' => 'Opsuite\\Promotion\\ResultBase',
      'ArrayOfTransactionLineBenefit' => 'Opsuite\\Promotion\\ArrayOfTransactionLineBenefit',
      'TransactionLineBenefit' => 'Opsuite\\Promotion\\TransactionLineBenefit',
      'ArrayOfTransactionBenefit' => 'Opsuite\\Promotion\\ArrayOfTransactionBenefit',
      'TransactionBenefit' => 'Opsuite\\Promotion\\TransactionBenefit',
      'Basket' => 'Opsuite\\Promotion\\Basket',
      'ArrayOfBasketLine' => 'Opsuite\\Promotion\\ArrayOfBasketLine',
      'BasketLine' => 'Opsuite\\Promotion\\BasketLine',
      'ApplyPromotionsResult' => 'Opsuite\\Promotion\\ApplyPromotionsResult',
      'ProcessedBasket' => 'Opsuite\\Promotion\\ProcessedBasket',
      'ArrayOfProcessedBasketLine' => 'Opsuite\\Promotion\\ArrayOfProcessedBasketLine',
      'ProcessedBasketLine' => 'Opsuite\\Promotion\\ProcessedBasketLine',
      'ReloadPromotionsResult' => 'Opsuite\\Promotion\\ReloadPromotionsResult',
      'GetEmptyBasket' => 'Opsuite\\Promotion\\GetEmptyBasket',
      'GetEmptyBasketResponse' => 'Opsuite\\Promotion\\GetEmptyBasketResponse',
      'GetEmptyBasketLine' => 'Opsuite\\Promotion\\GetEmptyBasketLine',
      'GetEmptyBasketLineResponse' => 'Opsuite\\Promotion\\GetEmptyBasketLineResponse',
      'ApplyPromotions' => 'Opsuite\\Promotion\\ApplyPromotions',
      'ApplyPromotionsResponse' => 'Opsuite\\Promotion\\ApplyPromotionsResponse',
      'ReloadPromotions' => 'Opsuite\\Promotion\\ReloadPromotions',
      'ReloadPromotionsResponse' => 'Opsuite\\Promotion\\ReloadPromotionsResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/PromotionService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetEmptyBasket $parameters
     * @return GetEmptyBasketResponse
     */
    public function GetEmptyBasket(GetEmptyBasket $parameters)
    {
      return $this->__soapCall('GetEmptyBasket', array($parameters));
    }

    /**
     * @param GetEmptyBasketLine $parameters
     * @return GetEmptyBasketLineResponse
     */
    public function GetEmptyBasketLine(GetEmptyBasketLine $parameters)
    {
      return $this->__soapCall('GetEmptyBasketLine', array($parameters));
    }

    /**
     * @param ApplyPromotions $parameters
     * @return ApplyPromotionsResponse
     */
    public function ApplyPromotions(ApplyPromotions $parameters)
    {
      return $this->__soapCall('ApplyPromotions', array($parameters));
    }

    /**
     * @param ReloadPromotions $parameters
     * @return ReloadPromotionsResponse
     */
    public function ReloadPromotions(ReloadPromotions $parameters)
    {
      return $this->__soapCall('ReloadPromotions', array($parameters));
    }

}
