<?php

namespace Opsuite\Promotion;

class ProcessedBasketLine extends ResultBase
{

    /**
     * @var ArrayOfTransactionLineBenefit $LineBenefits
     */
    protected $LineBenefits = null;

    /**
     * @var string $ProductCode
     */
    protected $ProductCode = null;

    /**
     * @var float $Quantity
     */
    protected $Quantity = null;

    /**
     * @var string $SourceLineIdentifier
     */
    protected $SourceLineIdentifier = null;

    /**
     * @var float $UnitPrice
     */
    protected $UnitPrice = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return ArrayOfTransactionLineBenefit
     */
    public function getLineBenefits()
    {
      return $this->LineBenefits;
    }

    /**
     * @param ArrayOfTransactionLineBenefit $LineBenefits
     * @return \Opsuite\Promotion\ProcessedBasketLine
     */
    public function setLineBenefits($LineBenefits)
    {
      $this->LineBenefits = $LineBenefits;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductCode()
    {
      return $this->ProductCode;
    }

    /**
     * @param string $ProductCode
     * @return \Opsuite\Promotion\ProcessedBasketLine
     */
    public function setProductCode($ProductCode)
    {
      $this->ProductCode = $ProductCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
      return $this->Quantity;
    }

    /**
     * @param float $Quantity
     * @return \Opsuite\Promotion\ProcessedBasketLine
     */
    public function setQuantity($Quantity)
    {
      $this->Quantity = $Quantity;
      return $this;
    }

    /**
     * @return string
     */
    public function getSourceLineIdentifier()
    {
      return $this->SourceLineIdentifier;
    }

    /**
     * @param string $SourceLineIdentifier
     * @return \Opsuite\Promotion\ProcessedBasketLine
     */
    public function setSourceLineIdentifier($SourceLineIdentifier)
    {
      $this->SourceLineIdentifier = $SourceLineIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitPrice()
    {
      return $this->UnitPrice;
    }

    /**
     * @param float $UnitPrice
     * @return \Opsuite\Promotion\ProcessedBasketLine
     */
    public function setUnitPrice($UnitPrice)
    {
      $this->UnitPrice = $UnitPrice;
      return $this;
    }

}
