<?php

namespace Opsuite\Promotion;

class ProcessedBasket
{

    /**
     * @var ArrayOfProcessedBasketLine $BasketLines
     */
    protected $BasketLines = null;

    /**
     * @var ArrayOfTransactionBenefit $Benefits
     */
    protected $Benefits = null;

    /**
     * @var string $CustomerAccountNumber
     */
    protected $CustomerAccountNumber = null;

    /**
     * @var string $LocationCode
     */
    protected $LocationCode = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ArrayOfProcessedBasketLine
     */
    public function getBasketLines()
    {
      return $this->BasketLines;
    }

    /**
     * @param ArrayOfProcessedBasketLine $BasketLines
     * @return \Opsuite\Promotion\ProcessedBasket
     */
    public function setBasketLines($BasketLines)
    {
      $this->BasketLines = $BasketLines;
      return $this;
    }

    /**
     * @return ArrayOfTransactionBenefit
     */
    public function getBenefits()
    {
      return $this->Benefits;
    }

    /**
     * @param ArrayOfTransactionBenefit $Benefits
     * @return \Opsuite\Promotion\ProcessedBasket
     */
    public function setBenefits($Benefits)
    {
      $this->Benefits = $Benefits;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerAccountNumber()
    {
      return $this->CustomerAccountNumber;
    }

    /**
     * @param string $CustomerAccountNumber
     * @return \Opsuite\Promotion\ProcessedBasket
     */
    public function setCustomerAccountNumber($CustomerAccountNumber)
    {
      $this->CustomerAccountNumber = $CustomerAccountNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationCode()
    {
      return $this->LocationCode;
    }

    /**
     * @param string $LocationCode
     * @return \Opsuite\Promotion\ProcessedBasket
     */
    public function setLocationCode($LocationCode)
    {
      $this->LocationCode = $LocationCode;
      return $this;
    }

}
