<?php

namespace Opsuite\Promotion;

class BasketLine
{

    /**
     * @var boolean $IgnoreInPromotions
     */
    protected $IgnoreInPromotions = null;

    /**
     * @var string $LineIdentifier
     */
    protected $LineIdentifier = null;

    /**
     * @var string $ProductCode
     */
    protected $ProductCode = null;

    /**
     * @var float $Quantity
     */
    protected $Quantity = null;

    /**
     * @var float $UnitPrice
     */
    protected $UnitPrice = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return boolean
     */
    public function getIgnoreInPromotions()
    {
      return $this->IgnoreInPromotions;
    }

    /**
     * @param boolean $IgnoreInPromotions
     * @return \Opsuite\Promotion\BasketLine
     */
    public function setIgnoreInPromotions($IgnoreInPromotions)
    {
      $this->IgnoreInPromotions = $IgnoreInPromotions;
      return $this;
    }

    /**
     * @return string
     */
    public function getLineIdentifier()
    {
      return $this->LineIdentifier;
    }

    /**
     * @param string $LineIdentifier
     * @return \Opsuite\Promotion\BasketLine
     */
    public function setLineIdentifier($LineIdentifier)
    {
      $this->LineIdentifier = $LineIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductCode()
    {
      return $this->ProductCode;
    }

    /**
     * @param string $ProductCode
     * @return \Opsuite\Promotion\BasketLine
     */
    public function setProductCode($ProductCode)
    {
      $this->ProductCode = $ProductCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
      return $this->Quantity;
    }

    /**
     * @param float $Quantity
     * @return \Opsuite\Promotion\BasketLine
     */
    public function setQuantity($Quantity)
    {
      $this->Quantity = $Quantity;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitPrice()
    {
      return $this->UnitPrice;
    }

    /**
     * @param float $UnitPrice
     * @return \Opsuite\Promotion\BasketLine
     */
    public function setUnitPrice($UnitPrice)
    {
      $this->UnitPrice = $UnitPrice;
      return $this;
    }

}
