<?php

namespace Opsuite\Promotion;

class ArrayOfProcessedBasketLine implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ProcessedBasketLine[] $ProcessedBasketLine
     */
    protected $ProcessedBasketLine = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ProcessedBasketLine[]
     */
    public function getProcessedBasketLine()
    {
      return $this->ProcessedBasketLine;
    }

    /**
     * @param ProcessedBasketLine[] $ProcessedBasketLine
     * @return \Opsuite\Promotion\ArrayOfProcessedBasketLine
     */
    public function setProcessedBasketLine(array $ProcessedBasketLine = null)
    {
      $this->ProcessedBasketLine = $ProcessedBasketLine;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ProcessedBasketLine[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ProcessedBasketLine
     */
    public function offsetGet($offset)
    {
      return $this->ProcessedBasketLine[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ProcessedBasketLine $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ProcessedBasketLine[] = $value;
      } else {
        $this->ProcessedBasketLine[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ProcessedBasketLine[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ProcessedBasketLine Return the current element
     */
    public function current()
    {
      return current($this->ProcessedBasketLine);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ProcessedBasketLine);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ProcessedBasketLine);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ProcessedBasketLine);
    }

    /**
     * Countable implementation
     *
     * @return ProcessedBasketLine Return count of elements
     */
    public function count()
    {
      return count($this->ProcessedBasketLine);
    }

}
