<?php

namespace Opsuite\Inventory;

class SubmitItemsToMatrix
{

    /**
     * @var string $matrixSku
     */
    protected $matrixSku = null;

    /**
     * @var ArrayOfstring $skuList
     */
    protected $skuList = null;

    /**
     * @param string $matrixSku
     * @param ArrayOfstring $skuList
     */
    public function __construct($matrixSku, $skuList)
    {
      $this->matrixSku = $matrixSku;
      $this->skuList = $skuList;
    }

    /**
     * @return string
     */
    public function getMatrixSku()
    {
      return $this->matrixSku;
    }

    /**
     * @param string $matrixSku
     * @return \Opsuite\Inventory\SubmitItemsToMatrix
     */
    public function setMatrixSku($matrixSku)
    {
      $this->matrixSku = $matrixSku;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getSkuList()
    {
      return $this->skuList;
    }

    /**
     * @param ArrayOfstring $skuList
     * @return \Opsuite\Inventory\SubmitItemsToMatrix
     */
    public function setSkuList($skuList)
    {
      $this->skuList = $skuList;
      return $this;
    }

}
