<?php

namespace Opsuite\Inventory;

class SubmitItemMasters
{

    /**
     * @var ArrayOfItemMaster $itemMasters
     */
    protected $itemMasters = null;

    /**
     * @var boolean $updateAllLocations
     */
    protected $updateAllLocations = null;

    /**
     * @var boolean $addNewItemsToAllLocations
     */
    protected $addNewItemsToAllLocations = null;

    /**
     * @param ArrayOfItemMaster $itemMasters
     * @param boolean $updateAllLocations
     * @param boolean $addNewItemsToAllLocations
     */
    public function __construct($itemMasters, $updateAllLocations, $addNewItemsToAllLocations)
    {
      $this->itemMasters = $itemMasters;
      $this->updateAllLocations = $updateAllLocations;
      $this->addNewItemsToAllLocations = $addNewItemsToAllLocations;
    }

    /**
     * @return ArrayOfItemMaster
     */
    public function getItemMasters()
    {
      return $this->itemMasters;
    }

    /**
     * @param ArrayOfItemMaster $itemMasters
     * @return \Opsuite\Inventory\SubmitItemMasters
     */
    public function setItemMasters($itemMasters)
    {
      $this->itemMasters = $itemMasters;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getUpdateAllLocations()
    {
      return $this->updateAllLocations;
    }

    /**
     * @param boolean $updateAllLocations
     * @return \Opsuite\Inventory\SubmitItemMasters
     */
    public function setUpdateAllLocations($updateAllLocations)
    {
      $this->updateAllLocations = $updateAllLocations;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getAddNewItemsToAllLocations()
    {
      return $this->addNewItemsToAllLocations;
    }

    /**
     * @param boolean $addNewItemsToAllLocations
     * @return \Opsuite\Inventory\SubmitItemMasters
     */
    public function setAddNewItemsToAllLocations($addNewItemsToAllLocations)
    {
      $this->addNewItemsToAllLocations = $addNewItemsToAllLocations;
      return $this;
    }

}
