<?php

namespace Opsuite\Inventory;

class SpecialOffer
{

    /**
     * @var SpecialOfferAccountTypeScopeEnum $AccountTypeScope
     */
    protected $AccountTypeScope = null;

    /**
     * @var ArrayOfAccountType $AccountTypes
     */
    protected $AccountTypes = null;

    /**
     * @var boolean $Active
     */
    protected $Active = null;

    /**
     * @var string $Code
     */
    protected $Code = null;

    /**
     * @var ArrayOfCommunity $Communities
     */
    protected $Communities = null;

    /**
     * @var SpecialOfferCommunityScopeEnum $CommunityScope
     */
    protected $CommunityScope = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var \DateTime $EndDate
     */
    protected $EndDate = null;

    /**
     * @var \DateTime $LastUpdated
     */
    protected $LastUpdated = null;

    /**
     * @var int $MaxApplies
     */
    protected $MaxApplies = null;

    /**
     * @var int $Priority
     */
    protected $Priority = null;

    /**
     * @var string $ReasonCode
     */
    protected $ReasonCode = null;

    /**
     * @var string $Schedule
     */
    protected $Schedule = null;

    /**
     * @var int $SpecialOfferId
     */
    protected $SpecialOfferId = null;

    /**
     * @var SpecialOfferSpecialOfferTypeEnum $SpecialOfferType
     */
    protected $SpecialOfferType = null;

    /**
     * @var \DateTime $StartDate
     */
    protected $StartDate = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SpecialOfferAccountTypeScopeEnum
     */
    public function getAccountTypeScope()
    {
      return $this->AccountTypeScope;
    }

    /**
     * @param SpecialOfferAccountTypeScopeEnum $AccountTypeScope
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setAccountTypeScope($AccountTypeScope)
    {
      $this->AccountTypeScope = $AccountTypeScope;
      return $this;
    }

    /**
     * @return ArrayOfAccountType
     */
    public function getAccountTypes()
    {
      return $this->AccountTypes;
    }

    /**
     * @param ArrayOfAccountType $AccountTypes
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setAccountTypes($AccountTypes)
    {
      $this->AccountTypes = $AccountTypes;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getActive()
    {
      return $this->Active;
    }

    /**
     * @param boolean $Active
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setActive($Active)
    {
      $this->Active = $Active;
      return $this;
    }

    /**
     * @return string
     */
    public function getCode()
    {
      return $this->Code;
    }

    /**
     * @param string $Code
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setCode($Code)
    {
      $this->Code = $Code;
      return $this;
    }

    /**
     * @return ArrayOfCommunity
     */
    public function getCommunities()
    {
      return $this->Communities;
    }

    /**
     * @param ArrayOfCommunity $Communities
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setCommunities($Communities)
    {
      $this->Communities = $Communities;
      return $this;
    }

    /**
     * @return SpecialOfferCommunityScopeEnum
     */
    public function getCommunityScope()
    {
      return $this->CommunityScope;
    }

    /**
     * @param SpecialOfferCommunityScopeEnum $CommunityScope
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setCommunityScope($CommunityScope)
    {
      $this->CommunityScope = $CommunityScope;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->EndDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->EndDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $EndDate
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setEndDate(\DateTime $EndDate = null)
    {
      if ($EndDate == null) {
       $this->EndDate = null;
      } else {
        $this->EndDate = $EndDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->LastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdated
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setLastUpdated(\DateTime $LastUpdated = null)
    {
      if ($LastUpdated == null) {
       $this->LastUpdated = null;
      } else {
        $this->LastUpdated = $LastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxApplies()
    {
      return $this->MaxApplies;
    }

    /**
     * @param int $MaxApplies
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setMaxApplies($MaxApplies)
    {
      $this->MaxApplies = $MaxApplies;
      return $this;
    }

    /**
     * @return int
     */
    public function getPriority()
    {
      return $this->Priority;
    }

    /**
     * @param int $Priority
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setPriority($Priority)
    {
      $this->Priority = $Priority;
      return $this;
    }

    /**
     * @return string
     */
    public function getReasonCode()
    {
      return $this->ReasonCode;
    }

    /**
     * @param string $ReasonCode
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setReasonCode($ReasonCode)
    {
      $this->ReasonCode = $ReasonCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getSchedule()
    {
      return $this->Schedule;
    }

    /**
     * @param string $Schedule
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setSchedule($Schedule)
    {
      $this->Schedule = $Schedule;
      return $this;
    }

    /**
     * @return int
     */
    public function getSpecialOfferId()
    {
      return $this->SpecialOfferId;
    }

    /**
     * @param int $SpecialOfferId
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setSpecialOfferId($SpecialOfferId)
    {
      $this->SpecialOfferId = $SpecialOfferId;
      return $this;
    }

    /**
     * @return SpecialOfferSpecialOfferTypeEnum
     */
    public function getSpecialOfferType()
    {
      return $this->SpecialOfferType;
    }

    /**
     * @param SpecialOfferSpecialOfferTypeEnum $SpecialOfferType
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setSpecialOfferType($SpecialOfferType)
    {
      $this->SpecialOfferType = $SpecialOfferType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->StartDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->StartDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $StartDate
     * @return \Opsuite\Inventory\SpecialOffer
     */
    public function setStartDate(\DateTime $StartDate = null)
    {
      if ($StartDate == null) {
       $this->StartDate = null;
      } else {
        $this->StartDate = $StartDate->format(\DateTime::ATOM);
      }
      return $this;
    }

}
