<?php

namespace Opsuite\Inventory;

class RedeemPromotionCoupon
{

    /**
     * @var string $serialNumber
     */
    protected $serialNumber = null;

    /**
     * @var int $transactionNumber
     */
    protected $transactionNumber = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var \DateTime $redemptionDate
     */
    protected $redemptionDate = null;

    /**
     * @var int $customerId
     */
    protected $customerId = null;

    /**
     * @var int $cashierId
     */
    protected $cashierId = null;

    /**
     * @param string $serialNumber
     * @param int $transactionNumber
     * @param int $locationId
     * @param \DateTime $redemptionDate
     * @param int $customerId
     * @param int $cashierId
     */
    public function __construct($serialNumber, $transactionNumber, $locationId, \DateTime $redemptionDate, $customerId, $cashierId)
    {
      $this->serialNumber = $serialNumber;
      $this->transactionNumber = $transactionNumber;
      $this->locationId = $locationId;
      $this->redemptionDate = $redemptionDate->format(\DateTime::ATOM);
      $this->customerId = $customerId;
      $this->cashierId = $cashierId;
    }

    /**
     * @return string
     */
    public function getSerialNumber()
    {
      return $this->serialNumber;
    }

    /**
     * @param string $serialNumber
     * @return \Opsuite\Inventory\RedeemPromotionCoupon
     */
    public function setSerialNumber($serialNumber)
    {
      $this->serialNumber = $serialNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getTransactionNumber()
    {
      return $this->transactionNumber;
    }

    /**
     * @param int $transactionNumber
     * @return \Opsuite\Inventory\RedeemPromotionCoupon
     */
    public function setTransactionNumber($transactionNumber)
    {
      $this->transactionNumber = $transactionNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Inventory\RedeemPromotionCoupon
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getRedemptionDate()
    {
      if ($this->redemptionDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->redemptionDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $redemptionDate
     * @return \Opsuite\Inventory\RedeemPromotionCoupon
     */
    public function setRedemptionDate(\DateTime $redemptionDate)
    {
      $this->redemptionDate = $redemptionDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->customerId;
    }

    /**
     * @param int $customerId
     * @return \Opsuite\Inventory\RedeemPromotionCoupon
     */
    public function setCustomerId($customerId)
    {
      $this->customerId = $customerId;
      return $this;
    }

    /**
     * @return int
     */
    public function getCashierId()
    {
      return $this->cashierId;
    }

    /**
     * @param int $cashierId
     * @return \Opsuite\Inventory\RedeemPromotionCoupon
     */
    public function setCashierId($cashierId)
    {
      $this->cashierId = $cashierId;
      return $this;
    }

}
