<?php

namespace Opsuite\Inventory;

class RedeemBounceBackVoucher
{

    /**
     * @var int $issueId
     */
    protected $issueId = null;

    /**
     * @var int $transactionNumber
     */
    protected $transactionNumber = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var \DateTime $redemptionDate
     */
    protected $redemptionDate = null;

    /**
     * @var int $customerId
     */
    protected $customerId = null;

    /**
     * @var int $cashierId
     */
    protected $cashierId = null;

    /**
     * @param int $issueId
     * @param int $transactionNumber
     * @param int $locationId
     * @param \DateTime $redemptionDate
     * @param int $customerId
     * @param int $cashierId
     */
    public function __construct($issueId, $transactionNumber, $locationId, \DateTime $redemptionDate, $customerId, $cashierId)
    {
      $this->issueId = $issueId;
      $this->transactionNumber = $transactionNumber;
      $this->locationId = $locationId;
      $this->redemptionDate = $redemptionDate->format(\DateTime::ATOM);
      $this->customerId = $customerId;
      $this->cashierId = $cashierId;
    }

    /**
     * @return int
     */
    public function getIssueId()
    {
      return $this->issueId;
    }

    /**
     * @param int $issueId
     * @return \Opsuite\Inventory\RedeemBounceBackVoucher
     */
    public function setIssueId($issueId)
    {
      $this->issueId = $issueId;
      return $this;
    }

    /**
     * @return int
     */
    public function getTransactionNumber()
    {
      return $this->transactionNumber;
    }

    /**
     * @param int $transactionNumber
     * @return \Opsuite\Inventory\RedeemBounceBackVoucher
     */
    public function setTransactionNumber($transactionNumber)
    {
      $this->transactionNumber = $transactionNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Inventory\RedeemBounceBackVoucher
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getRedemptionDate()
    {
      if ($this->redemptionDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->redemptionDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $redemptionDate
     * @return \Opsuite\Inventory\RedeemBounceBackVoucher
     */
    public function setRedemptionDate(\DateTime $redemptionDate)
    {
      $this->redemptionDate = $redemptionDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->customerId;
    }

    /**
     * @param int $customerId
     * @return \Opsuite\Inventory\RedeemBounceBackVoucher
     */
    public function setCustomerId($customerId)
    {
      $this->customerId = $customerId;
      return $this;
    }

    /**
     * @return int
     */
    public function getCashierId()
    {
      return $this->cashierId;
    }

    /**
     * @param int $cashierId
     * @return \Opsuite\Inventory\RedeemBounceBackVoucher
     */
    public function setCashierId($cashierId)
    {
      $this->cashierId = $cashierId;
      return $this;
    }

}
