<?php

namespace Opsuite\Inventory;

class PromotionCouponDetail
{

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var int $IssueId
     */
    protected $IssueId = null;

    /**
     * @var int $NumberOfUses
     */
    protected $NumberOfUses = null;

    /**
     * @var \DateTime $RedeemedDate
     */
    protected $RedeemedDate = null;

    /**
     * @var string $SerialNumber
     */
    protected $SerialNumber = null;

    /**
     * @var string $Title
     */
    protected $Title = null;

    /**
     * @var \DateTime $ValidFrom
     */
    protected $ValidFrom = null;

    /**
     * @var \DateTime $ValidTo
     */
    protected $ValidTo = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Inventory\PromotionCouponDetail
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return int
     */
    public function getIssueId()
    {
      return $this->IssueId;
    }

    /**
     * @param int $IssueId
     * @return \Opsuite\Inventory\PromotionCouponDetail
     */
    public function setIssueId($IssueId)
    {
      $this->IssueId = $IssueId;
      return $this;
    }

    /**
     * @return int
     */
    public function getNumberOfUses()
    {
      return $this->NumberOfUses;
    }

    /**
     * @param int $NumberOfUses
     * @return \Opsuite\Inventory\PromotionCouponDetail
     */
    public function setNumberOfUses($NumberOfUses)
    {
      $this->NumberOfUses = $NumberOfUses;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getRedeemedDate()
    {
      if ($this->RedeemedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->RedeemedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $RedeemedDate
     * @return \Opsuite\Inventory\PromotionCouponDetail
     */
    public function setRedeemedDate(\DateTime $RedeemedDate = null)
    {
      if ($RedeemedDate == null) {
       $this->RedeemedDate = null;
      } else {
        $this->RedeemedDate = $RedeemedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getSerialNumber()
    {
      return $this->SerialNumber;
    }

    /**
     * @param string $SerialNumber
     * @return \Opsuite\Inventory\PromotionCouponDetail
     */
    public function setSerialNumber($SerialNumber)
    {
      $this->SerialNumber = $SerialNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
      return $this->Title;
    }

    /**
     * @param string $Title
     * @return \Opsuite\Inventory\PromotionCouponDetail
     */
    public function setTitle($Title)
    {
      $this->Title = $Title;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getValidFrom()
    {
      if ($this->ValidFrom == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ValidFrom);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ValidFrom
     * @return \Opsuite\Inventory\PromotionCouponDetail
     */
    public function setValidFrom(\DateTime $ValidFrom = null)
    {
      if ($ValidFrom == null) {
       $this->ValidFrom = null;
      } else {
        $this->ValidFrom = $ValidFrom->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getValidTo()
    {
      if ($this->ValidTo == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ValidTo);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ValidTo
     * @return \Opsuite\Inventory\PromotionCouponDetail
     */
    public function setValidTo(\DateTime $ValidTo = null)
    {
      if ($ValidTo == null) {
       $this->ValidTo = null;
      } else {
        $this->ValidTo = $ValidTo->format(\DateTime::ATOM);
      }
      return $this;
    }

}
