<?php

namespace Opsuite\Inventory;

class MatrixMaster
{

    /**
     * @var boolean $Active
     */
    protected $Active = null;

    /**
     * @var int $BarcodeFormat
     */
    protected $BarcodeFormat = null;

    /**
     * @var int $CategoryId
     */
    protected $CategoryId = null;

    /**
     * @var float $Cost
     */
    protected $Cost = null;

    /**
     * @var int $DepartmentId
     */
    protected $DepartmentId = null;

    /**
     * @var string $DescriptionFormula
     */
    protected $DescriptionFormula = null;

    /**
     * @var string $DimensionOne
     */
    protected $DimensionOne = null;

    /**
     * @var string $DimensionThree
     */
    protected $DimensionThree = null;

    /**
     * @var string $DimensionTwo
     */
    protected $DimensionTwo = null;

    /**
     * @var boolean $DoNotOrder
     */
    protected $DoNotOrder = null;

    /**
     * @var string $ExtendedDescription
     */
    protected $ExtendedDescription = null;

    /**
     * @var boolean $IncrementalSkuNumbering
     */
    protected $IncrementalSkuNumbering = null;

    /**
     * @var int $ItemTypeId
     */
    protected $ItemTypeId = null;

    /**
     * @var ArrayOfstring $Locations
     */
    protected $Locations = null;

    /**
     * @var string $Manufacturer
     */
    protected $Manufacturer = null;

    /**
     * @var string $MatrixDescription
     */
    protected $MatrixDescription = null;

    /**
     * @var ArrayOfMatrixItem $MatrixItems
     */
    protected $MatrixItems = null;

    /**
     * @var string $MatrixSku
     */
    protected $MatrixSku = null;

    /**
     * @var float $MaxRestockLevel
     */
    protected $MaxRestockLevel = null;

    /**
     * @var float $MinReorderPoint
     */
    protected $MinReorderPoint = null;

    /**
     * @var float $Msrp
     */
    protected $Msrp = null;

    /**
     * @var float $Price
     */
    protected $Price = null;

    /**
     * @var float $PriceIncTax
     */
    protected $PriceIncTax = null;

    /**
     * @var int $PrimaryVendorId
     */
    protected $PrimaryVendorId = null;

    /**
     * @var string $ProductLine
     */
    protected $ProductLine = null;

    /**
     * @var string $SkuFormula
     */
    protected $SkuFormula = null;

    /**
     * @var string $SkuSeparator
     */
    protected $SkuSeparator = null;

    /**
     * @var string $Style
     */
    protected $Style = null;

    /**
     * @var string $SubDescription1
     */
    protected $SubDescription1 = null;

    /**
     * @var string $SubDescription2
     */
    protected $SubDescription2 = null;

    /**
     * @var string $SubDescription3
     */
    protected $SubDescription3 = null;

    /**
     * @var boolean $Taxable
     */
    protected $Taxable = null;

    /**
     * @var int $TaxableGroupId
     */
    protected $TaxableGroupId = null;

    /**
     * @var int $UnitOfMeasureId
     */
    protected $UnitOfMeasureId = null;

    /**
     * @var boolean $UseSkuSeperator
     */
    protected $UseSkuSeperator = null;

    /**
     * @var boolean $WebItem
     */
    protected $WebItem = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return boolean
     */
    public function getActive()
    {
      return $this->Active;
    }

    /**
     * @param boolean $Active
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setActive($Active)
    {
      $this->Active = $Active;
      return $this;
    }

    /**
     * @return int
     */
    public function getBarcodeFormat()
    {
      return $this->BarcodeFormat;
    }

    /**
     * @param int $BarcodeFormat
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setBarcodeFormat($BarcodeFormat)
    {
      $this->BarcodeFormat = $BarcodeFormat;
      return $this;
    }

    /**
     * @return int
     */
    public function getCategoryId()
    {
      return $this->CategoryId;
    }

    /**
     * @param int $CategoryId
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setCategoryId($CategoryId)
    {
      $this->CategoryId = $CategoryId;
      return $this;
    }

    /**
     * @return float
     */
    public function getCost()
    {
      return $this->Cost;
    }

    /**
     * @param float $Cost
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setCost($Cost)
    {
      $this->Cost = $Cost;
      return $this;
    }

    /**
     * @return int
     */
    public function getDepartmentId()
    {
      return $this->DepartmentId;
    }

    /**
     * @param int $DepartmentId
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setDepartmentId($DepartmentId)
    {
      $this->DepartmentId = $DepartmentId;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescriptionFormula()
    {
      return $this->DescriptionFormula;
    }

    /**
     * @param string $DescriptionFormula
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setDescriptionFormula($DescriptionFormula)
    {
      $this->DescriptionFormula = $DescriptionFormula;
      return $this;
    }

    /**
     * @return string
     */
    public function getDimensionOne()
    {
      return $this->DimensionOne;
    }

    /**
     * @param string $DimensionOne
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setDimensionOne($DimensionOne)
    {
      $this->DimensionOne = $DimensionOne;
      return $this;
    }

    /**
     * @return string
     */
    public function getDimensionThree()
    {
      return $this->DimensionThree;
    }

    /**
     * @param string $DimensionThree
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setDimensionThree($DimensionThree)
    {
      $this->DimensionThree = $DimensionThree;
      return $this;
    }

    /**
     * @return string
     */
    public function getDimensionTwo()
    {
      return $this->DimensionTwo;
    }

    /**
     * @param string $DimensionTwo
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setDimensionTwo($DimensionTwo)
    {
      $this->DimensionTwo = $DimensionTwo;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDoNotOrder()
    {
      return $this->DoNotOrder;
    }

    /**
     * @param boolean $DoNotOrder
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setDoNotOrder($DoNotOrder)
    {
      $this->DoNotOrder = $DoNotOrder;
      return $this;
    }

    /**
     * @return string
     */
    public function getExtendedDescription()
    {
      return $this->ExtendedDescription;
    }

    /**
     * @param string $ExtendedDescription
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setExtendedDescription($ExtendedDescription)
    {
      $this->ExtendedDescription = $ExtendedDescription;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncrementalSkuNumbering()
    {
      return $this->IncrementalSkuNumbering;
    }

    /**
     * @param boolean $IncrementalSkuNumbering
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setIncrementalSkuNumbering($IncrementalSkuNumbering)
    {
      $this->IncrementalSkuNumbering = $IncrementalSkuNumbering;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemTypeId()
    {
      return $this->ItemTypeId;
    }

    /**
     * @param int $ItemTypeId
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setItemTypeId($ItemTypeId)
    {
      $this->ItemTypeId = $ItemTypeId;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getLocations()
    {
      return $this->Locations;
    }

    /**
     * @param ArrayOfstring $Locations
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setLocations($Locations)
    {
      $this->Locations = $Locations;
      return $this;
    }

    /**
     * @return string
     */
    public function getManufacturer()
    {
      return $this->Manufacturer;
    }

    /**
     * @param string $Manufacturer
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setManufacturer($Manufacturer)
    {
      $this->Manufacturer = $Manufacturer;
      return $this;
    }

    /**
     * @return string
     */
    public function getMatrixDescription()
    {
      return $this->MatrixDescription;
    }

    /**
     * @param string $MatrixDescription
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setMatrixDescription($MatrixDescription)
    {
      $this->MatrixDescription = $MatrixDescription;
      return $this;
    }

    /**
     * @return ArrayOfMatrixItem
     */
    public function getMatrixItems()
    {
      return $this->MatrixItems;
    }

    /**
     * @param ArrayOfMatrixItem $MatrixItems
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setMatrixItems($MatrixItems)
    {
      $this->MatrixItems = $MatrixItems;
      return $this;
    }

    /**
     * @return string
     */
    public function getMatrixSku()
    {
      return $this->MatrixSku;
    }

    /**
     * @param string $MatrixSku
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setMatrixSku($MatrixSku)
    {
      $this->MatrixSku = $MatrixSku;
      return $this;
    }

    /**
     * @return float
     */
    public function getMaxRestockLevel()
    {
      return $this->MaxRestockLevel;
    }

    /**
     * @param float $MaxRestockLevel
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setMaxRestockLevel($MaxRestockLevel)
    {
      $this->MaxRestockLevel = $MaxRestockLevel;
      return $this;
    }

    /**
     * @return float
     */
    public function getMinReorderPoint()
    {
      return $this->MinReorderPoint;
    }

    /**
     * @param float $MinReorderPoint
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setMinReorderPoint($MinReorderPoint)
    {
      $this->MinReorderPoint = $MinReorderPoint;
      return $this;
    }

    /**
     * @return float
     */
    public function getMsrp()
    {
      return $this->Msrp;
    }

    /**
     * @param float $Msrp
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setMsrp($Msrp)
    {
      $this->Msrp = $Msrp;
      return $this;
    }

    /**
     * @return float
     */
    public function getPrice()
    {
      return $this->Price;
    }

    /**
     * @param float $Price
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setPrice($Price)
    {
      $this->Price = $Price;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceIncTax()
    {
      return $this->PriceIncTax;
    }

    /**
     * @param float $PriceIncTax
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setPriceIncTax($PriceIncTax)
    {
      $this->PriceIncTax = $PriceIncTax;
      return $this;
    }

    /**
     * @return int
     */
    public function getPrimaryVendorId()
    {
      return $this->PrimaryVendorId;
    }

    /**
     * @param int $PrimaryVendorId
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setPrimaryVendorId($PrimaryVendorId)
    {
      $this->PrimaryVendorId = $PrimaryVendorId;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductLine()
    {
      return $this->ProductLine;
    }

    /**
     * @param string $ProductLine
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setProductLine($ProductLine)
    {
      $this->ProductLine = $ProductLine;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuFormula()
    {
      return $this->SkuFormula;
    }

    /**
     * @param string $SkuFormula
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setSkuFormula($SkuFormula)
    {
      $this->SkuFormula = $SkuFormula;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuSeparator()
    {
      return $this->SkuSeparator;
    }

    /**
     * @param string $SkuSeparator
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setSkuSeparator($SkuSeparator)
    {
      $this->SkuSeparator = $SkuSeparator;
      return $this;
    }

    /**
     * @return string
     */
    public function getStyle()
    {
      return $this->Style;
    }

    /**
     * @param string $Style
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setStyle($Style)
    {
      $this->Style = $Style;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubDescription1()
    {
      return $this->SubDescription1;
    }

    /**
     * @param string $SubDescription1
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setSubDescription1($SubDescription1)
    {
      $this->SubDescription1 = $SubDescription1;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubDescription2()
    {
      return $this->SubDescription2;
    }

    /**
     * @param string $SubDescription2
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setSubDescription2($SubDescription2)
    {
      $this->SubDescription2 = $SubDescription2;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubDescription3()
    {
      return $this->SubDescription3;
    }

    /**
     * @param string $SubDescription3
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setSubDescription3($SubDescription3)
    {
      $this->SubDescription3 = $SubDescription3;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getTaxable()
    {
      return $this->Taxable;
    }

    /**
     * @param boolean $Taxable
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setTaxable($Taxable)
    {
      $this->Taxable = $Taxable;
      return $this;
    }

    /**
     * @return int
     */
    public function getTaxableGroupId()
    {
      return $this->TaxableGroupId;
    }

    /**
     * @param int $TaxableGroupId
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setTaxableGroupId($TaxableGroupId)
    {
      $this->TaxableGroupId = $TaxableGroupId;
      return $this;
    }

    /**
     * @return int
     */
    public function getUnitOfMeasureId()
    {
      return $this->UnitOfMeasureId;
    }

    /**
     * @param int $UnitOfMeasureId
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setUnitOfMeasureId($UnitOfMeasureId)
    {
      $this->UnitOfMeasureId = $UnitOfMeasureId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getUseSkuSeperator()
    {
      return $this->UseSkuSeperator;
    }

    /**
     * @param boolean $UseSkuSeperator
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setUseSkuSeperator($UseSkuSeperator)
    {
      $this->UseSkuSeperator = $UseSkuSeperator;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getWebItem()
    {
      return $this->WebItem;
    }

    /**
     * @param boolean $WebItem
     * @return \Opsuite\Inventory\MatrixMaster
     */
    public function setWebItem($WebItem)
    {
      $this->WebItem = $WebItem;
      return $this;
    }

}
