<?php

namespace Opsuite\Inventory;

class MatrixItem
{

    /**
     * @var boolean $Active
     */
    protected $Active = null;

    /**
     * @var string $Dimension1
     */
    protected $Dimension1 = null;

    /**
     * @var string $Dimension2
     */
    protected $Dimension2 = null;

    /**
     * @var string $Dimension3
     */
    protected $Dimension3 = null;

    /**
     * @var int $Id
     */
    protected $Id = null;

    /**
     * @var ItemMaster $ItemMaster
     */
    protected $ItemMaster = null;

    /**
     * @var int $ItemMasterId
     */
    protected $ItemMasterId = null;

    /**
     * @var \DateTime $LastUpdated
     */
    protected $LastUpdated = null;

    /**
     * @var int $MatrixMasterId
     */
    protected $MatrixMasterId = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return boolean
     */
    public function getActive()
    {
      return $this->Active;
    }

    /**
     * @param boolean $Active
     * @return \Opsuite\Inventory\MatrixItem
     */
    public function setActive($Active)
    {
      $this->Active = $Active;
      return $this;
    }

    /**
     * @return string
     */
    public function getDimension1()
    {
      return $this->Dimension1;
    }

    /**
     * @param string $Dimension1
     * @return \Opsuite\Inventory\MatrixItem
     */
    public function setDimension1($Dimension1)
    {
      $this->Dimension1 = $Dimension1;
      return $this;
    }

    /**
     * @return string
     */
    public function getDimension2()
    {
      return $this->Dimension2;
    }

    /**
     * @param string $Dimension2
     * @return \Opsuite\Inventory\MatrixItem
     */
    public function setDimension2($Dimension2)
    {
      $this->Dimension2 = $Dimension2;
      return $this;
    }

    /**
     * @return string
     */
    public function getDimension3()
    {
      return $this->Dimension3;
    }

    /**
     * @param string $Dimension3
     * @return \Opsuite\Inventory\MatrixItem
     */
    public function setDimension3($Dimension3)
    {
      $this->Dimension3 = $Dimension3;
      return $this;
    }

    /**
     * @return int
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param int $Id
     * @return \Opsuite\Inventory\MatrixItem
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return ItemMaster
     */
    public function getItemMaster()
    {
      return $this->ItemMaster;
    }

    /**
     * @param ItemMaster $ItemMaster
     * @return \Opsuite\Inventory\MatrixItem
     */
    public function setItemMaster($ItemMaster)
    {
      $this->ItemMaster = $ItemMaster;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemMasterId()
    {
      return $this->ItemMasterId;
    }

    /**
     * @param int $ItemMasterId
     * @return \Opsuite\Inventory\MatrixItem
     */
    public function setItemMasterId($ItemMasterId)
    {
      $this->ItemMasterId = $ItemMasterId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->LastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdated
     * @return \Opsuite\Inventory\MatrixItem
     */
    public function setLastUpdated(\DateTime $LastUpdated = null)
    {
      if ($LastUpdated == null) {
       $this->LastUpdated = null;
      } else {
        $this->LastUpdated = $LastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getMatrixMasterId()
    {
      return $this->MatrixMasterId;
    }

    /**
     * @param int $MatrixMasterId
     * @return \Opsuite\Inventory\MatrixItem
     */
    public function setMatrixMasterId($MatrixMasterId)
    {
      $this->MatrixMasterId = $MatrixMasterId;
      return $this;
    }

}
