<?php

namespace Opsuite\Inventory;

class ManualAdjustmentDocument
{

    /**
     * @var \DateTime $ChangeDate
     */
    protected $ChangeDate = null;

    /**
     * @var int $InventoryControlDocumentId
     */
    protected $InventoryControlDocumentId = null;

    /**
     * @var ArrayOfManualAdjustmentLine $Lines
     */
    protected $Lines = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var int $ManualAdjustmentDocumentId
     */
    protected $ManualAdjustmentDocumentId = null;

    /**
     * @var int $ReasonCodeId
     */
    protected $ReasonCodeId = null;

    /**
     * @var int $UserId
     */
    protected $UserId = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return \DateTime
     */
    public function getChangeDate()
    {
      if ($this->ChangeDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ChangeDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ChangeDate
     * @return \Opsuite\Inventory\ManualAdjustmentDocument
     */
    public function setChangeDate(\DateTime $ChangeDate = null)
    {
      if ($ChangeDate == null) {
       $this->ChangeDate = null;
      } else {
        $this->ChangeDate = $ChangeDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getInventoryControlDocumentId()
    {
      return $this->InventoryControlDocumentId;
    }

    /**
     * @param int $InventoryControlDocumentId
     * @return \Opsuite\Inventory\ManualAdjustmentDocument
     */
    public function setInventoryControlDocumentId($InventoryControlDocumentId)
    {
      $this->InventoryControlDocumentId = $InventoryControlDocumentId;
      return $this;
    }

    /**
     * @return ArrayOfManualAdjustmentLine
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfManualAdjustmentLine $Lines
     * @return \Opsuite\Inventory\ManualAdjustmentDocument
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\Inventory\ManualAdjustmentDocument
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return int
     */
    public function getManualAdjustmentDocumentId()
    {
      return $this->ManualAdjustmentDocumentId;
    }

    /**
     * @param int $ManualAdjustmentDocumentId
     * @return \Opsuite\Inventory\ManualAdjustmentDocument
     */
    public function setManualAdjustmentDocumentId($ManualAdjustmentDocumentId)
    {
      $this->ManualAdjustmentDocumentId = $ManualAdjustmentDocumentId;
      return $this;
    }

    /**
     * @return int
     */
    public function getReasonCodeId()
    {
      return $this->ReasonCodeId;
    }

    /**
     * @param int $ReasonCodeId
     * @return \Opsuite\Inventory\ManualAdjustmentDocument
     */
    public function setReasonCodeId($ReasonCodeId)
    {
      $this->ReasonCodeId = $ReasonCodeId;
      return $this;
    }

    /**
     * @return int
     */
    public function getUserId()
    {
      return $this->UserId;
    }

    /**
     * @param int $UserId
     * @return \Opsuite\Inventory\ManualAdjustmentDocument
     */
    public function setUserId($UserId)
    {
      $this->UserId = $UserId;
      return $this;
    }

}
