<?php

namespace Opsuite\Inventory;

class ItemMasterWithSpecialOffers
{

    /**
     * @var int $ItemMasterId
     */
    protected $ItemMasterId = null;

    /**
     * @var \DateTime $LastUpdated
     */
    protected $LastUpdated = null;

    /**
     * @var string $Sku
     */
    protected $Sku = null;

    /**
     * @var ArrayOfSpecialOffer $SpecialOffers
     */
    protected $SpecialOffers = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return int
     */
    public function getItemMasterId()
    {
      return $this->ItemMasterId;
    }

    /**
     * @param int $ItemMasterId
     * @return \Opsuite\Inventory\ItemMasterWithSpecialOffers
     */
    public function setItemMasterId($ItemMasterId)
    {
      $this->ItemMasterId = $ItemMasterId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->LastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdated
     * @return \Opsuite\Inventory\ItemMasterWithSpecialOffers
     */
    public function setLastUpdated(\DateTime $LastUpdated = null)
    {
      if ($LastUpdated == null) {
       $this->LastUpdated = null;
      } else {
        $this->LastUpdated = $LastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getSku()
    {
      return $this->Sku;
    }

    /**
     * @param string $Sku
     * @return \Opsuite\Inventory\ItemMasterWithSpecialOffers
     */
    public function setSku($Sku)
    {
      $this->Sku = $Sku;
      return $this;
    }

    /**
     * @return ArrayOfSpecialOffer
     */
    public function getSpecialOffers()
    {
      return $this->SpecialOffers;
    }

    /**
     * @param ArrayOfSpecialOffer $SpecialOffers
     * @return \Opsuite\Inventory\ItemMasterWithSpecialOffers
     */
    public function setSpecialOffers($SpecialOffers)
    {
      $this->SpecialOffers = $SpecialOffers;
      return $this;
    }

}
