<?php

namespace Opsuite\Inventory;

class ItemMaster
{

    /**
     * @var boolean $Active
     */
    protected $Active = null;

    /**
     * @var string $Alias
     */
    protected $Alias = null;

    /**
     * @var ArrayOfAttributePair $Attributes
     */
    protected $Attributes = null;

    /**
     * @var int $BarcodeFormat
     */
    protected $BarcodeFormat = null;

    /**
     * @var string $BarcodeNumber
     */
    protected $BarcodeNumber = null;

    /**
     * @var int $CategoryId
     */
    protected $CategoryId = null;

    /**
     * @var float $Cost
     */
    protected $Cost = null;

    /**
     * @var boolean $DefaultPOLevel
     */
    protected $DefaultPOLevel = null;

    /**
     * @var int $DepartmentId
     */
    protected $DepartmentId = null;

    /**
     * @var float $Depth
     */
    protected $Depth = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var boolean $DoNotOrder
     */
    protected $DoNotOrder = null;

    /**
     * @var string $ExtendedDescription
     */
    protected $ExtendedDescription = null;

    /**
     * @var float $Height
     */
    protected $Height = null;

    /**
     * @var int $ItemMasterId
     */
    protected $ItemMasterId = null;

    /**
     * @var int $ItemTypeId
     */
    protected $ItemTypeId = null;

    /**
     * @var \DateTime $LastUpdated
     */
    protected $LastUpdated = null;

    /**
     * @var string $Manufacturer
     */
    protected $Manufacturer = null;

    /**
     * @var ArrayOfstring $MatrixAssociations
     */
    protected $MatrixAssociations = null;

    /**
     * @var string $MatrixSku
     */
    protected $MatrixSku = null;

    /**
     * @var float $MaxRestockLevel
     */
    protected $MaxRestockLevel = null;

    /**
     * @var float $MinReorderPoint
     */
    protected $MinReorderPoint = null;

    /**
     * @var float $Msrp
     */
    protected $Msrp = null;

    /**
     * @var string $Notes
     */
    protected $Notes = null;

    /**
     * @var string $ParentSku
     */
    protected $ParentSku = null;

    /**
     * @var float $Price
     */
    protected $Price = null;

    /**
     * @var float $PriceA
     */
    protected $PriceA = null;

    /**
     * @var float $PriceAIncTax
     */
    protected $PriceAIncTax = null;

    /**
     * @var float $PriceB
     */
    protected $PriceB = null;

    /**
     * @var float $PriceBIncTax
     */
    protected $PriceBIncTax = null;

    /**
     * @var float $PriceC
     */
    protected $PriceC = null;

    /**
     * @var float $PriceCIncTax
     */
    protected $PriceCIncTax = null;

    /**
     * @var float $PriceIncTax
     */
    protected $PriceIncTax = null;

    /**
     * @var float $PrimaryVendorCost
     */
    protected $PrimaryVendorCost = null;

    /**
     * @var int $PrimaryVendorId
     */
    protected $PrimaryVendorId = null;

    /**
     * @var int $PrimaryVendorMasterPackQuantity
     */
    protected $PrimaryVendorMasterPackQuantity = null;

    /**
     * @var float $PrimaryVendorMinimumOrder
     */
    protected $PrimaryVendorMinimumOrder = null;

    /**
     * @var string $PrimaryVendorReOrderNumber
     */
    protected $PrimaryVendorReOrderNumber = null;

    /**
     * @var float $PrimaryVendorTaxRate
     */
    protected $PrimaryVendorTaxRate = null;

    /**
     * @var string $ProductLine
     */
    protected $ProductLine = null;

    /**
     * @var float $QtyInParent
     */
    protected $QtyInParent = null;

    /**
     * @var float $SalePrice
     */
    protected $SalePrice = null;

    /**
     * @var float $SalePriceIncTax
     */
    protected $SalePriceIncTax = null;

    /**
     * @var string $Sku
     */
    protected $Sku = null;

    /**
     * @var ArrayOfSpecialOffer $SpecialOffers
     */
    protected $SpecialOffers = null;

    /**
     * @var string $SubDescription1
     */
    protected $SubDescription1 = null;

    /**
     * @var string $SubDescription2
     */
    protected $SubDescription2 = null;

    /**
     * @var string $SubDescription3
     */
    protected $SubDescription3 = null;

    /**
     * @var ArrayOfstring $TagAlongItemSkus
     */
    protected $TagAlongItemSkus = null;

    /**
     * @var boolean $Taxable
     */
    protected $Taxable = null;

    /**
     * @var int $TaxableGroupId
     */
    protected $TaxableGroupId = null;

    /**
     * @var int $UnitOfMeasureId
     */
    protected $UnitOfMeasureId = null;

    /**
     * @var WebContent $WebContent
     */
    protected $WebContent = null;

    /**
     * @var boolean $WebItem
     */
    protected $WebItem = null;

    /**
     * @var ArrayOfWebLink $WebLinks
     */
    protected $WebLinks = null;

    /**
     * @var float $Weight
     */
    protected $Weight = null;

    /**
     * @var float $Width
     */
    protected $Width = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return boolean
     */
    public function getActive()
    {
      return $this->Active;
    }

    /**
     * @param boolean $Active
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setActive($Active)
    {
      $this->Active = $Active;
      return $this;
    }

    /**
     * @return string
     */
    public function getAlias()
    {
      return $this->Alias;
    }

    /**
     * @param string $Alias
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setAlias($Alias)
    {
      $this->Alias = $Alias;
      return $this;
    }

    /**
     * @return ArrayOfAttributePair
     */
    public function getAttributes()
    {
      return $this->Attributes;
    }

    /**
     * @param ArrayOfAttributePair $Attributes
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setAttributes($Attributes)
    {
      $this->Attributes = $Attributes;
      return $this;
    }

    /**
     * @return int
     */
    public function getBarcodeFormat()
    {
      return $this->BarcodeFormat;
    }

    /**
     * @param int $BarcodeFormat
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setBarcodeFormat($BarcodeFormat)
    {
      $this->BarcodeFormat = $BarcodeFormat;
      return $this;
    }

    /**
     * @return string
     */
    public function getBarcodeNumber()
    {
      return $this->BarcodeNumber;
    }

    /**
     * @param string $BarcodeNumber
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setBarcodeNumber($BarcodeNumber)
    {
      $this->BarcodeNumber = $BarcodeNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getCategoryId()
    {
      return $this->CategoryId;
    }

    /**
     * @param int $CategoryId
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setCategoryId($CategoryId)
    {
      $this->CategoryId = $CategoryId;
      return $this;
    }

    /**
     * @return float
     */
    public function getCost()
    {
      return $this->Cost;
    }

    /**
     * @param float $Cost
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setCost($Cost)
    {
      $this->Cost = $Cost;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDefaultPOLevel()
    {
      return $this->DefaultPOLevel;
    }

    /**
     * @param boolean $DefaultPOLevel
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setDefaultPOLevel($DefaultPOLevel)
    {
      $this->DefaultPOLevel = $DefaultPOLevel;
      return $this;
    }

    /**
     * @return int
     */
    public function getDepartmentId()
    {
      return $this->DepartmentId;
    }

    /**
     * @param int $DepartmentId
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setDepartmentId($DepartmentId)
    {
      $this->DepartmentId = $DepartmentId;
      return $this;
    }

    /**
     * @return float
     */
    public function getDepth()
    {
      return $this->Depth;
    }

    /**
     * @param float $Depth
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setDepth($Depth)
    {
      $this->Depth = $Depth;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDoNotOrder()
    {
      return $this->DoNotOrder;
    }

    /**
     * @param boolean $DoNotOrder
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setDoNotOrder($DoNotOrder)
    {
      $this->DoNotOrder = $DoNotOrder;
      return $this;
    }

    /**
     * @return string
     */
    public function getExtendedDescription()
    {
      return $this->ExtendedDescription;
    }

    /**
     * @param string $ExtendedDescription
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setExtendedDescription($ExtendedDescription)
    {
      $this->ExtendedDescription = $ExtendedDescription;
      return $this;
    }

    /**
     * @return float
     */
    public function getHeight()
    {
      return $this->Height;
    }

    /**
     * @param float $Height
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setHeight($Height)
    {
      $this->Height = $Height;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemMasterId()
    {
      return $this->ItemMasterId;
    }

    /**
     * @param int $ItemMasterId
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setItemMasterId($ItemMasterId)
    {
      $this->ItemMasterId = $ItemMasterId;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemTypeId()
    {
      return $this->ItemTypeId;
    }

    /**
     * @param int $ItemTypeId
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setItemTypeId($ItemTypeId)
    {
      $this->ItemTypeId = $ItemTypeId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->LastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdated
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setLastUpdated(\DateTime $LastUpdated = null)
    {
      if ($LastUpdated == null) {
       $this->LastUpdated = null;
      } else {
        $this->LastUpdated = $LastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getManufacturer()
    {
      return $this->Manufacturer;
    }

    /**
     * @param string $Manufacturer
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setManufacturer($Manufacturer)
    {
      $this->Manufacturer = $Manufacturer;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getMatrixAssociations()
    {
      return $this->MatrixAssociations;
    }

    /**
     * @param ArrayOfstring $MatrixAssociations
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setMatrixAssociations($MatrixAssociations)
    {
      $this->MatrixAssociations = $MatrixAssociations;
      return $this;
    }

    /**
     * @return string
     */
    public function getMatrixSku()
    {
      return $this->MatrixSku;
    }

    /**
     * @param string $MatrixSku
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setMatrixSku($MatrixSku)
    {
      $this->MatrixSku = $MatrixSku;
      return $this;
    }

    /**
     * @return float
     */
    public function getMaxRestockLevel()
    {
      return $this->MaxRestockLevel;
    }

    /**
     * @param float $MaxRestockLevel
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setMaxRestockLevel($MaxRestockLevel)
    {
      $this->MaxRestockLevel = $MaxRestockLevel;
      return $this;
    }

    /**
     * @return float
     */
    public function getMinReorderPoint()
    {
      return $this->MinReorderPoint;
    }

    /**
     * @param float $MinReorderPoint
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setMinReorderPoint($MinReorderPoint)
    {
      $this->MinReorderPoint = $MinReorderPoint;
      return $this;
    }

    /**
     * @return float
     */
    public function getMsrp()
    {
      return $this->Msrp;
    }

    /**
     * @param float $Msrp
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setMsrp($Msrp)
    {
      $this->Msrp = $Msrp;
      return $this;
    }

    /**
     * @return string
     */
    public function getNotes()
    {
      return $this->Notes;
    }

    /**
     * @param string $Notes
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setNotes($Notes)
    {
      $this->Notes = $Notes;
      return $this;
    }

    /**
     * @return string
     */
    public function getParentSku()
    {
      return $this->ParentSku;
    }

    /**
     * @param string $ParentSku
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setParentSku($ParentSku)
    {
      $this->ParentSku = $ParentSku;
      return $this;
    }

    /**
     * @return float
     */
    public function getPrice()
    {
      return $this->Price;
    }

    /**
     * @param float $Price
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPrice($Price)
    {
      $this->Price = $Price;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceA()
    {
      return $this->PriceA;
    }

    /**
     * @param float $PriceA
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPriceA($PriceA)
    {
      $this->PriceA = $PriceA;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceAIncTax()
    {
      return $this->PriceAIncTax;
    }

    /**
     * @param float $PriceAIncTax
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPriceAIncTax($PriceAIncTax)
    {
      $this->PriceAIncTax = $PriceAIncTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceB()
    {
      return $this->PriceB;
    }

    /**
     * @param float $PriceB
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPriceB($PriceB)
    {
      $this->PriceB = $PriceB;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceBIncTax()
    {
      return $this->PriceBIncTax;
    }

    /**
     * @param float $PriceBIncTax
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPriceBIncTax($PriceBIncTax)
    {
      $this->PriceBIncTax = $PriceBIncTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceC()
    {
      return $this->PriceC;
    }

    /**
     * @param float $PriceC
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPriceC($PriceC)
    {
      $this->PriceC = $PriceC;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceCIncTax()
    {
      return $this->PriceCIncTax;
    }

    /**
     * @param float $PriceCIncTax
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPriceCIncTax($PriceCIncTax)
    {
      $this->PriceCIncTax = $PriceCIncTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceIncTax()
    {
      return $this->PriceIncTax;
    }

    /**
     * @param float $PriceIncTax
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPriceIncTax($PriceIncTax)
    {
      $this->PriceIncTax = $PriceIncTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getPrimaryVendorCost()
    {
      return $this->PrimaryVendorCost;
    }

    /**
     * @param float $PrimaryVendorCost
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPrimaryVendorCost($PrimaryVendorCost)
    {
      $this->PrimaryVendorCost = $PrimaryVendorCost;
      return $this;
    }

    /**
     * @return int
     */
    public function getPrimaryVendorId()
    {
      return $this->PrimaryVendorId;
    }

    /**
     * @param int $PrimaryVendorId
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPrimaryVendorId($PrimaryVendorId)
    {
      $this->PrimaryVendorId = $PrimaryVendorId;
      return $this;
    }

    /**
     * @return int
     */
    public function getPrimaryVendorMasterPackQuantity()
    {
      return $this->PrimaryVendorMasterPackQuantity;
    }

    /**
     * @param int $PrimaryVendorMasterPackQuantity
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPrimaryVendorMasterPackQuantity($PrimaryVendorMasterPackQuantity)
    {
      $this->PrimaryVendorMasterPackQuantity = $PrimaryVendorMasterPackQuantity;
      return $this;
    }

    /**
     * @return float
     */
    public function getPrimaryVendorMinimumOrder()
    {
      return $this->PrimaryVendorMinimumOrder;
    }

    /**
     * @param float $PrimaryVendorMinimumOrder
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPrimaryVendorMinimumOrder($PrimaryVendorMinimumOrder)
    {
      $this->PrimaryVendorMinimumOrder = $PrimaryVendorMinimumOrder;
      return $this;
    }

    /**
     * @return string
     */
    public function getPrimaryVendorReOrderNumber()
    {
      return $this->PrimaryVendorReOrderNumber;
    }

    /**
     * @param string $PrimaryVendorReOrderNumber
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPrimaryVendorReOrderNumber($PrimaryVendorReOrderNumber)
    {
      $this->PrimaryVendorReOrderNumber = $PrimaryVendorReOrderNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getPrimaryVendorTaxRate()
    {
      return $this->PrimaryVendorTaxRate;
    }

    /**
     * @param float $PrimaryVendorTaxRate
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setPrimaryVendorTaxRate($PrimaryVendorTaxRate)
    {
      $this->PrimaryVendorTaxRate = $PrimaryVendorTaxRate;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductLine()
    {
      return $this->ProductLine;
    }

    /**
     * @param string $ProductLine
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setProductLine($ProductLine)
    {
      $this->ProductLine = $ProductLine;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyInParent()
    {
      return $this->QtyInParent;
    }

    /**
     * @param float $QtyInParent
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setQtyInParent($QtyInParent)
    {
      $this->QtyInParent = $QtyInParent;
      return $this;
    }

    /**
     * @return float
     */
    public function getSalePrice()
    {
      return $this->SalePrice;
    }

    /**
     * @param float $SalePrice
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setSalePrice($SalePrice)
    {
      $this->SalePrice = $SalePrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getSalePriceIncTax()
    {
      return $this->SalePriceIncTax;
    }

    /**
     * @param float $SalePriceIncTax
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setSalePriceIncTax($SalePriceIncTax)
    {
      $this->SalePriceIncTax = $SalePriceIncTax;
      return $this;
    }

    /**
     * @return string
     */
    public function getSku()
    {
      return $this->Sku;
    }

    /**
     * @param string $Sku
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setSku($Sku)
    {
      $this->Sku = $Sku;
      return $this;
    }

    /**
     * @return ArrayOfSpecialOffer
     */
    public function getSpecialOffers()
    {
      return $this->SpecialOffers;
    }

    /**
     * @param ArrayOfSpecialOffer $SpecialOffers
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setSpecialOffers($SpecialOffers)
    {
      $this->SpecialOffers = $SpecialOffers;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubDescription1()
    {
      return $this->SubDescription1;
    }

    /**
     * @param string $SubDescription1
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setSubDescription1($SubDescription1)
    {
      $this->SubDescription1 = $SubDescription1;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubDescription2()
    {
      return $this->SubDescription2;
    }

    /**
     * @param string $SubDescription2
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setSubDescription2($SubDescription2)
    {
      $this->SubDescription2 = $SubDescription2;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubDescription3()
    {
      return $this->SubDescription3;
    }

    /**
     * @param string $SubDescription3
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setSubDescription3($SubDescription3)
    {
      $this->SubDescription3 = $SubDescription3;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getTagAlongItemSkus()
    {
      return $this->TagAlongItemSkus;
    }

    /**
     * @param ArrayOfstring $TagAlongItemSkus
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setTagAlongItemSkus($TagAlongItemSkus)
    {
      $this->TagAlongItemSkus = $TagAlongItemSkus;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getTaxable()
    {
      return $this->Taxable;
    }

    /**
     * @param boolean $Taxable
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setTaxable($Taxable)
    {
      $this->Taxable = $Taxable;
      return $this;
    }

    /**
     * @return int
     */
    public function getTaxableGroupId()
    {
      return $this->TaxableGroupId;
    }

    /**
     * @param int $TaxableGroupId
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setTaxableGroupId($TaxableGroupId)
    {
      $this->TaxableGroupId = $TaxableGroupId;
      return $this;
    }

    /**
     * @return int
     */
    public function getUnitOfMeasureId()
    {
      return $this->UnitOfMeasureId;
    }

    /**
     * @param int $UnitOfMeasureId
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setUnitOfMeasureId($UnitOfMeasureId)
    {
      $this->UnitOfMeasureId = $UnitOfMeasureId;
      return $this;
    }

    /**
     * @return WebContent
     */
    public function getWebContent()
    {
      return $this->WebContent;
    }

    /**
     * @param WebContent $WebContent
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setWebContent($WebContent)
    {
      $this->WebContent = $WebContent;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getWebItem()
    {
      return $this->WebItem;
    }

    /**
     * @param boolean $WebItem
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setWebItem($WebItem)
    {
      $this->WebItem = $WebItem;
      return $this;
    }

    /**
     * @return ArrayOfWebLink
     */
    public function getWebLinks()
    {
      return $this->WebLinks;
    }

    /**
     * @param ArrayOfWebLink $WebLinks
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setWebLinks($WebLinks)
    {
      $this->WebLinks = $WebLinks;
      return $this;
    }

    /**
     * @return float
     */
    public function getWeight()
    {
      return $this->Weight;
    }

    /**
     * @param float $Weight
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setWeight($Weight)
    {
      $this->Weight = $Weight;
      return $this;
    }

    /**
     * @return float
     */
    public function getWidth()
    {
      return $this->Width;
    }

    /**
     * @param float $Width
     * @return \Opsuite\Inventory\ItemMaster
     */
    public function setWidth($Width)
    {
      $this->Width = $Width;
      return $this;
    }

}
