<?php

namespace Opsuite\Inventory;

class ItemLocationDetail
{

    /**
     * @var boolean $Active
     */
    protected $Active = null;

    /**
     * @var boolean $AllowBackorder
     */
    protected $AllowBackorder = null;

    /**
     * @var float $Cost
     */
    protected $Cost = null;

    /**
     * @var boolean $DoNotSell
     */
    protected $DoNotSell = null;

    /**
     * @var \DateTime $FirstInventoryDate
     */
    protected $FirstInventoryDate = null;

    /**
     * @var int $Id
     */
    protected $Id = null;

    /**
     * @var int $ItemMasterId
     */
    protected $ItemMasterId = null;

    /**
     * @var float $LastCost
     */
    protected $LastCost = null;

    /**
     * @var \DateTime $LastRecieved
     */
    protected $LastRecieved = null;

    /**
     * @var \DateTime $LastSold
     */
    protected $LastSold = null;

    /**
     * @var \DateTime $LastUpdated
     */
    protected $LastUpdated = null;

    /**
     * @var string $LocationDescription
     */
    protected $LocationDescription = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var float $MaxRestockLevel
     */
    protected $MaxRestockLevel = null;

    /**
     * @var float $MinReorderPoint
     */
    protected $MinReorderPoint = null;

    /**
     * @var boolean $NotAvailableForOrder
     */
    protected $NotAvailableForOrder = null;

    /**
     * @var float $Price
     */
    protected $Price = null;

    /**
     * @var float $PriceA
     */
    protected $PriceA = null;

    /**
     * @var float $PriceAIncTax
     */
    protected $PriceAIncTax = null;

    /**
     * @var float $PriceB
     */
    protected $PriceB = null;

    /**
     * @var float $PriceBIncTax
     */
    protected $PriceBIncTax = null;

    /**
     * @var float $PriceC
     */
    protected $PriceC = null;

    /**
     * @var float $PriceCIncTax
     */
    protected $PriceCIncTax = null;

    /**
     * @var float $PriceIncTax
     */
    protected $PriceIncTax = null;

    /**
     * @var float $QtyAvailable
     */
    protected $QtyAvailable = null;

    /**
     * @var float $QtyCommited
     */
    protected $QtyCommited = null;

    /**
     * @var float $QtyOffline
     */
    protected $QtyOffline = null;

    /**
     * @var float $QtyOnHand
     */
    protected $QtyOnHand = null;

    /**
     * @var float $QtyOnOrder
     */
    protected $QtyOnOrder = null;

    /**
     * @var float $QtyOnTransfer
     */
    protected $QtyOnTransfer = null;

    /**
     * @var \DateTime $SaleEndDate
     */
    protected $SaleEndDate = null;

    /**
     * @var float $SalePrice
     */
    protected $SalePrice = null;

    /**
     * @var float $SalePriceIncTax
     */
    protected $SalePriceIncTax = null;

    /**
     * @var \DateTime $SaleStartDate
     */
    protected $SaleStartDate = null;

    /**
     * @var string $Sku
     */
    protected $Sku = null;

    /**
     * @var boolean $Taxable
     */
    protected $Taxable = null;

    /**
     * @var int $TaxableGroupId
     */
    protected $TaxableGroupId = null;

    /**
     * @var boolean $WebItem
     */
    protected $WebItem = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return boolean
     */
    public function getActive()
    {
      return $this->Active;
    }

    /**
     * @param boolean $Active
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setActive($Active)
    {
      $this->Active = $Active;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getAllowBackorder()
    {
      return $this->AllowBackorder;
    }

    /**
     * @param boolean $AllowBackorder
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setAllowBackorder($AllowBackorder)
    {
      $this->AllowBackorder = $AllowBackorder;
      return $this;
    }

    /**
     * @return float
     */
    public function getCost()
    {
      return $this->Cost;
    }

    /**
     * @param float $Cost
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setCost($Cost)
    {
      $this->Cost = $Cost;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDoNotSell()
    {
      return $this->DoNotSell;
    }

    /**
     * @param boolean $DoNotSell
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setDoNotSell($DoNotSell)
    {
      $this->DoNotSell = $DoNotSell;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getFirstInventoryDate()
    {
      if ($this->FirstInventoryDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->FirstInventoryDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $FirstInventoryDate
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setFirstInventoryDate(\DateTime $FirstInventoryDate = null)
    {
      if ($FirstInventoryDate == null) {
       $this->FirstInventoryDate = null;
      } else {
        $this->FirstInventoryDate = $FirstInventoryDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param int $Id
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemMasterId()
    {
      return $this->ItemMasterId;
    }

    /**
     * @param int $ItemMasterId
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setItemMasterId($ItemMasterId)
    {
      $this->ItemMasterId = $ItemMasterId;
      return $this;
    }

    /**
     * @return float
     */
    public function getLastCost()
    {
      return $this->LastCost;
    }

    /**
     * @param float $LastCost
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setLastCost($LastCost)
    {
      $this->LastCost = $LastCost;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastRecieved()
    {
      if ($this->LastRecieved == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastRecieved);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastRecieved
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setLastRecieved(\DateTime $LastRecieved = null)
    {
      if ($LastRecieved == null) {
       $this->LastRecieved = null;
      } else {
        $this->LastRecieved = $LastRecieved->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastSold()
    {
      if ($this->LastSold == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastSold);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastSold
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setLastSold(\DateTime $LastSold = null)
    {
      if ($LastSold == null) {
       $this->LastSold = null;
      } else {
        $this->LastSold = $LastSold->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->LastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdated
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setLastUpdated(\DateTime $LastUpdated = null)
    {
      if ($LastUpdated == null) {
       $this->LastUpdated = null;
      } else {
        $this->LastUpdated = $LastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationDescription()
    {
      return $this->LocationDescription;
    }

    /**
     * @param string $LocationDescription
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setLocationDescription($LocationDescription)
    {
      $this->LocationDescription = $LocationDescription;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return float
     */
    public function getMaxRestockLevel()
    {
      return $this->MaxRestockLevel;
    }

    /**
     * @param float $MaxRestockLevel
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setMaxRestockLevel($MaxRestockLevel)
    {
      $this->MaxRestockLevel = $MaxRestockLevel;
      return $this;
    }

    /**
     * @return float
     */
    public function getMinReorderPoint()
    {
      return $this->MinReorderPoint;
    }

    /**
     * @param float $MinReorderPoint
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setMinReorderPoint($MinReorderPoint)
    {
      $this->MinReorderPoint = $MinReorderPoint;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNotAvailableForOrder()
    {
      return $this->NotAvailableForOrder;
    }

    /**
     * @param boolean $NotAvailableForOrder
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setNotAvailableForOrder($NotAvailableForOrder)
    {
      $this->NotAvailableForOrder = $NotAvailableForOrder;
      return $this;
    }

    /**
     * @return float
     */
    public function getPrice()
    {
      return $this->Price;
    }

    /**
     * @param float $Price
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setPrice($Price)
    {
      $this->Price = $Price;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceA()
    {
      return $this->PriceA;
    }

    /**
     * @param float $PriceA
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setPriceA($PriceA)
    {
      $this->PriceA = $PriceA;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceAIncTax()
    {
      return $this->PriceAIncTax;
    }

    /**
     * @param float $PriceAIncTax
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setPriceAIncTax($PriceAIncTax)
    {
      $this->PriceAIncTax = $PriceAIncTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceB()
    {
      return $this->PriceB;
    }

    /**
     * @param float $PriceB
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setPriceB($PriceB)
    {
      $this->PriceB = $PriceB;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceBIncTax()
    {
      return $this->PriceBIncTax;
    }

    /**
     * @param float $PriceBIncTax
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setPriceBIncTax($PriceBIncTax)
    {
      $this->PriceBIncTax = $PriceBIncTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceC()
    {
      return $this->PriceC;
    }

    /**
     * @param float $PriceC
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setPriceC($PriceC)
    {
      $this->PriceC = $PriceC;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceCIncTax()
    {
      return $this->PriceCIncTax;
    }

    /**
     * @param float $PriceCIncTax
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setPriceCIncTax($PriceCIncTax)
    {
      $this->PriceCIncTax = $PriceCIncTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getPriceIncTax()
    {
      return $this->PriceIncTax;
    }

    /**
     * @param float $PriceIncTax
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setPriceIncTax($PriceIncTax)
    {
      $this->PriceIncTax = $PriceIncTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyAvailable()
    {
      return $this->QtyAvailable;
    }

    /**
     * @param float $QtyAvailable
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setQtyAvailable($QtyAvailable)
    {
      $this->QtyAvailable = $QtyAvailable;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyCommited()
    {
      return $this->QtyCommited;
    }

    /**
     * @param float $QtyCommited
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setQtyCommited($QtyCommited)
    {
      $this->QtyCommited = $QtyCommited;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyOffline()
    {
      return $this->QtyOffline;
    }

    /**
     * @param float $QtyOffline
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setQtyOffline($QtyOffline)
    {
      $this->QtyOffline = $QtyOffline;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyOnHand()
    {
      return $this->QtyOnHand;
    }

    /**
     * @param float $QtyOnHand
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setQtyOnHand($QtyOnHand)
    {
      $this->QtyOnHand = $QtyOnHand;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyOnOrder()
    {
      return $this->QtyOnOrder;
    }

    /**
     * @param float $QtyOnOrder
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setQtyOnOrder($QtyOnOrder)
    {
      $this->QtyOnOrder = $QtyOnOrder;
      return $this;
    }

    /**
     * @return float
     */
    public function getQtyOnTransfer()
    {
      return $this->QtyOnTransfer;
    }

    /**
     * @param float $QtyOnTransfer
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setQtyOnTransfer($QtyOnTransfer)
    {
      $this->QtyOnTransfer = $QtyOnTransfer;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getSaleEndDate()
    {
      if ($this->SaleEndDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->SaleEndDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $SaleEndDate
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setSaleEndDate(\DateTime $SaleEndDate = null)
    {
      if ($SaleEndDate == null) {
       $this->SaleEndDate = null;
      } else {
        $this->SaleEndDate = $SaleEndDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return float
     */
    public function getSalePrice()
    {
      return $this->SalePrice;
    }

    /**
     * @param float $SalePrice
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setSalePrice($SalePrice)
    {
      $this->SalePrice = $SalePrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getSalePriceIncTax()
    {
      return $this->SalePriceIncTax;
    }

    /**
     * @param float $SalePriceIncTax
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setSalePriceIncTax($SalePriceIncTax)
    {
      $this->SalePriceIncTax = $SalePriceIncTax;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getSaleStartDate()
    {
      if ($this->SaleStartDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->SaleStartDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $SaleStartDate
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setSaleStartDate(\DateTime $SaleStartDate = null)
    {
      if ($SaleStartDate == null) {
       $this->SaleStartDate = null;
      } else {
        $this->SaleStartDate = $SaleStartDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getSku()
    {
      return $this->Sku;
    }

    /**
     * @param string $Sku
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setSku($Sku)
    {
      $this->Sku = $Sku;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getTaxable()
    {
      return $this->Taxable;
    }

    /**
     * @param boolean $Taxable
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setTaxable($Taxable)
    {
      $this->Taxable = $Taxable;
      return $this;
    }

    /**
     * @return int
     */
    public function getTaxableGroupId()
    {
      return $this->TaxableGroupId;
    }

    /**
     * @param int $TaxableGroupId
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setTaxableGroupId($TaxableGroupId)
    {
      $this->TaxableGroupId = $TaxableGroupId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getWebItem()
    {
      return $this->WebItem;
    }

    /**
     * @param boolean $WebItem
     * @return \Opsuite\Inventory\ItemLocationDetail
     */
    public function setWebItem($WebItem)
    {
      $this->WebItem = $WebItem;
      return $this;
    }

}
