<?php

namespace Opsuite\Inventory;

use Opsuite\WSSSoapClient;

class InventoryService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfAttributePair' => 'Opsuite\\Inventory\\ArrayOfAttributePair',
      'AttributePair' => 'Opsuite\\Inventory\\AttributePair',
      'ArrayOfstring' => 'Opsuite\\Inventory\\ArrayOfstring',
      'ArrayOfKeyValueOfintstring' => 'Opsuite\\Inventory\\ArrayOfKeyValueOfintstring',
      'KeyValueOfintstring' => 'Opsuite\\Inventory\\KeyValueOfintstring',
      'ArrayOfKeyValueOfshortstring' => 'Opsuite\\Inventory\\ArrayOfKeyValueOfshortstring',
      'KeyValueOfshortstring' => 'Opsuite\\Inventory\\KeyValueOfshortstring',
      'ArrayOfint' => 'Opsuite\\Inventory\\ArrayOfint',
      'ArrayOfAccountType' => 'Opsuite\\Inventory\\ArrayOfAccountType',
      'AccountType' => 'Opsuite\\Inventory\\AccountType',
      'ArrayOfCommunity' => 'Opsuite\\Inventory\\ArrayOfCommunity',
      'Community' => 'Opsuite\\Inventory\\Community',
      'ArrayOfSpecialOffer' => 'Opsuite\\Inventory\\ArrayOfSpecialOffer',
      'SpecialOffer' => 'Opsuite\\Inventory\\SpecialOffer',
      'ArrayOfSubmitResultOfItemMasterrM_S_P_Stlz' => 'Opsuite\\Inventory\\ArrayOfSubmitResultOfItemMasterrM_S_P_Stlz',
      'SubmitResultOfItemMasterrM_S_P_Stlz' => 'Opsuite\\Inventory\\SubmitResultOfItemMasterrM_S_P_Stlz',
      'ArrayOfErrorInfoOfItemMasterrM_S_P_Stlz' => 'Opsuite\\Inventory\\ArrayOfErrorInfoOfItemMasterrM_S_P_Stlz',
      'ErrorInfoOfItemMasterrM_S_P_Stlz' => 'Opsuite\\Inventory\\ErrorInfoOfItemMasterrM_S_P_Stlz',
      'ArrayOfSubmitResultOfItemLocationDetailrM_S_P_Stlz' => 'Opsuite\\Inventory\\ArrayOfSubmitResultOfItemLocationDetailrM_S_P_Stlz',
      'SubmitResultOfItemLocationDetailrM_S_P_Stlz' => 'Opsuite\\Inventory\\SubmitResultOfItemLocationDetailrM_S_P_Stlz',
      'ArrayOfErrorInfoOfItemLocationDetailrM_S_P_Stlz' => 'Opsuite\\Inventory\\ArrayOfErrorInfoOfItemLocationDetailrM_S_P_Stlz',
      'ErrorInfoOfItemLocationDetailrM_S_P_Stlz' => 'Opsuite\\Inventory\\ErrorInfoOfItemLocationDetailrM_S_P_Stlz',
      'SubmitResultOfDepartmentrM_S_P_Stlz' => 'Opsuite\\Inventory\\SubmitResultOfDepartmentrM_S_P_Stlz',
      'ArrayOfErrorInfoOfDepartmentrM_S_P_Stlz' => 'Opsuite\\Inventory\\ArrayOfErrorInfoOfDepartmentrM_S_P_Stlz',
      'ErrorInfoOfDepartmentrM_S_P_Stlz' => 'Opsuite\\Inventory\\ErrorInfoOfDepartmentrM_S_P_Stlz',
      'SubmitResultOfCategoryrM_S_P_Stlz' => 'Opsuite\\Inventory\\SubmitResultOfCategoryrM_S_P_Stlz',
      'ArrayOfErrorInfoOfCategoryrM_S_P_Stlz' => 'Opsuite\\Inventory\\ArrayOfErrorInfoOfCategoryrM_S_P_Stlz',
      'ErrorInfoOfCategoryrM_S_P_Stlz' => 'Opsuite\\Inventory\\ErrorInfoOfCategoryrM_S_P_Stlz',
      'SubmitResultOfstring' => 'Opsuite\\Inventory\\SubmitResultOfstring',
      'ArrayOfErrorInfoOfstring' => 'Opsuite\\Inventory\\ArrayOfErrorInfoOfstring',
      'ErrorInfoOfstring' => 'Opsuite\\Inventory\\ErrorInfoOfstring',
      'ArrayOfSubmitResultOfMatrixMasterrM_S_P_Stlz' => 'Opsuite\\Inventory\\ArrayOfSubmitResultOfMatrixMasterrM_S_P_Stlz',
      'SubmitResultOfMatrixMasterrM_S_P_Stlz' => 'Opsuite\\Inventory\\SubmitResultOfMatrixMasterrM_S_P_Stlz',
      'ArrayOfErrorInfoOfMatrixMasterrM_S_P_Stlz' => 'Opsuite\\Inventory\\ArrayOfErrorInfoOfMatrixMasterrM_S_P_Stlz',
      'ErrorInfoOfMatrixMasterrM_S_P_Stlz' => 'Opsuite\\Inventory\\ErrorInfoOfMatrixMasterrM_S_P_Stlz',
      'SubmitResultOfVendorrM_S_P_Stlz' => 'Opsuite\\Inventory\\SubmitResultOfVendorrM_S_P_Stlz',
      'ArrayOfErrorInfoOfVendorrM_S_P_Stlz' => 'Opsuite\\Inventory\\ArrayOfErrorInfoOfVendorrM_S_P_Stlz',
      'ErrorInfoOfVendorrM_S_P_Stlz' => 'Opsuite\\Inventory\\ErrorInfoOfVendorrM_S_P_Stlz',
      'PagedResultOfItemMasterrM_S_P_Stlz' => 'Opsuite\\Inventory\\PagedResultOfItemMasterrM_S_P_Stlz',
      'PagedResultOfItemLocationDetailrM_S_P_Stlz' => 'Opsuite\\Inventory\\PagedResultOfItemLocationDetailrM_S_P_Stlz',
      'PagedResultOfManualAdjustmentDocumentrM_S_P_Stlz' => 'Opsuite\\Inventory\\PagedResultOfManualAdjustmentDocumentrM_S_P_Stlz',
      'ArrayOfErrorInfo' => 'Opsuite\\Inventory\\ArrayOfErrorInfo',
      'ErrorInfo' => 'Opsuite\\Inventory\\ErrorInfo',
      'PagedResultOfItemMasterWithSpecialOffersrM_S_P_Stlz' => 'Opsuite\\Inventory\\PagedResultOfItemMasterWithSpecialOffersrM_S_P_Stlz',
      'ArrayOfItemMaster' => 'Opsuite\\Inventory\\ArrayOfItemMaster',
      'ItemMaster' => 'Opsuite\\Inventory\\ItemMaster',
      'WebContent' => 'Opsuite\\Inventory\\WebContent',
      'ArrayOfWebLink' => 'Opsuite\\Inventory\\ArrayOfWebLink',
      'WebLink' => 'Opsuite\\Inventory\\WebLink',
      'ArrayOfItemMasterAttributes' => 'Opsuite\\Inventory\\ArrayOfItemMasterAttributes',
      'ItemMasterAttributes' => 'Opsuite\\Inventory\\ItemMasterAttributes',
      'ArrayOfItemLocationDetail' => 'Opsuite\\Inventory\\ArrayOfItemLocationDetail',
      'ItemLocationDetail' => 'Opsuite\\Inventory\\ItemLocationDetail',
      'ArrayOfCategory' => 'Opsuite\\Inventory\\ArrayOfCategory',
      'Category' => 'Opsuite\\Inventory\\Category',
      'ArrayOfDepartment' => 'Opsuite\\Inventory\\ArrayOfDepartment',
      'Department' => 'Opsuite\\Inventory\\Department',
      'ArrayOfVendor' => 'Opsuite\\Inventory\\ArrayOfVendor',
      'Vendor' => 'Opsuite\\Inventory\\Vendor',
      'ArrayOfItemQuantity' => 'Opsuite\\Inventory\\ArrayOfItemQuantity',
      'ItemQuantity' => 'Opsuite\\Inventory\\ItemQuantity',
      'ArrayOfMatrixMaster' => 'Opsuite\\Inventory\\ArrayOfMatrixMaster',
      'MatrixMaster' => 'Opsuite\\Inventory\\MatrixMaster',
      'ArrayOfMatrixItem' => 'Opsuite\\Inventory\\ArrayOfMatrixItem',
      'MatrixItem' => 'Opsuite\\Inventory\\MatrixItem',
      'BounceBackVoucherDetail' => 'Opsuite\\Inventory\\BounceBackVoucherDetail',
      'DiscountCouponDetail' => 'Opsuite\\Inventory\\DiscountCouponDetail',
      'PromotionCouponDetail' => 'Opsuite\\Inventory\\PromotionCouponDetail',
      'ArrayOfProductPackage' => 'Opsuite\\Inventory\\ArrayOfProductPackage',
      'ProductPackage' => 'Opsuite\\Inventory\\ProductPackage',
      'ArrayOfManualAdjustmentDocument' => 'Opsuite\\Inventory\\ArrayOfManualAdjustmentDocument',
      'ManualAdjustmentDocument' => 'Opsuite\\Inventory\\ManualAdjustmentDocument',
      'ArrayOfManualAdjustmentLine' => 'Opsuite\\Inventory\\ArrayOfManualAdjustmentLine',
      'ManualAdjustmentLine' => 'Opsuite\\Inventory\\ManualAdjustmentLine',
      'ArrayOfInventoryAdjustment' => 'Opsuite\\Inventory\\ArrayOfInventoryAdjustment',
      'InventoryAdjustment' => 'Opsuite\\Inventory\\InventoryAdjustment',
      'ArrayOfSubmitInventoryAdjustmentResult' => 'Opsuite\\Inventory\\ArrayOfSubmitInventoryAdjustmentResult',
      'SubmitInventoryAdjustmentResult' => 'Opsuite\\Inventory\\SubmitInventoryAdjustmentResult',
      'ArrayOfItemMasterWithSpecialOffers' => 'Opsuite\\Inventory\\ArrayOfItemMasterWithSpecialOffers',
      'ItemMasterWithSpecialOffers' => 'Opsuite\\Inventory\\ItemMasterWithSpecialOffers',
      'GetItemMasters' => 'Opsuite\\Inventory\\GetItemMasters',
      'GetItemMastersResponse' => 'Opsuite\\Inventory\\GetItemMastersResponse',
      'GetWebItemMasters' => 'Opsuite\\Inventory\\GetWebItemMasters',
      'GetWebItemMastersResponse' => 'Opsuite\\Inventory\\GetWebItemMastersResponse',
      'GetItemMastersByLastUpdated' => 'Opsuite\\Inventory\\GetItemMastersByLastUpdated',
      'GetItemMastersByLastUpdatedResponse' => 'Opsuite\\Inventory\\GetItemMastersByLastUpdatedResponse',
      'GetItemMaster' => 'Opsuite\\Inventory\\GetItemMaster',
      'GetItemMasterResponse' => 'Opsuite\\Inventory\\GetItemMasterResponse',
      'GetItemMastersBySkus' => 'Opsuite\\Inventory\\GetItemMastersBySkus',
      'GetItemMastersBySkusResponse' => 'Opsuite\\Inventory\\GetItemMastersBySkusResponse',
      'GetItemMasterAttributesBySkus' => 'Opsuite\\Inventory\\GetItemMasterAttributesBySkus',
      'GetItemMasterAttributesBySkusResponse' => 'Opsuite\\Inventory\\GetItemMasterAttributesBySkusResponse',
      'SubmitItemMasters' => 'Opsuite\\Inventory\\SubmitItemMasters',
      'SubmitItemMastersResponse' => 'Opsuite\\Inventory\\SubmitItemMastersResponse',
      'SubmitItemLocationDetails' => 'Opsuite\\Inventory\\SubmitItemLocationDetails',
      'SubmitItemLocationDetailsResponse' => 'Opsuite\\Inventory\\SubmitItemLocationDetailsResponse',
      'GetCategories' => 'Opsuite\\Inventory\\GetCategories',
      'GetCategoriesResponse' => 'Opsuite\\Inventory\\GetCategoriesResponse',
      'GetCategoryNames' => 'Opsuite\\Inventory\\GetCategoryNames',
      'GetCategoryNamesResponse' => 'Opsuite\\Inventory\\GetCategoryNamesResponse',
      'GetDepartments' => 'Opsuite\\Inventory\\GetDepartments',
      'GetDepartmentsResponse' => 'Opsuite\\Inventory\\GetDepartmentsResponse',
      'GetDepartmentNames' => 'Opsuite\\Inventory\\GetDepartmentNames',
      'GetDepartmentNamesResponse' => 'Opsuite\\Inventory\\GetDepartmentNamesResponse',
      'GetUom' => 'Opsuite\\Inventory\\GetUom',
      'GetUomResponse' => 'Opsuite\\Inventory\\GetUomResponse',
      'GetBarCodeFormats' => 'Opsuite\\Inventory\\GetBarCodeFormats',
      'GetBarCodeFormatsResponse' => 'Opsuite\\Inventory\\GetBarCodeFormatsResponse',
      'GetItemTypes' => 'Opsuite\\Inventory\\GetItemTypes',
      'GetItemTypesResponse' => 'Opsuite\\Inventory\\GetItemTypesResponse',
      'GetVendors' => 'Opsuite\\Inventory\\GetVendors',
      'GetVendorsResponse' => 'Opsuite\\Inventory\\GetVendorsResponse',
      'GetVendorByVendorCode' => 'Opsuite\\Inventory\\GetVendorByVendorCode',
      'GetVendorByVendorCodeResponse' => 'Opsuite\\Inventory\\GetVendorByVendorCodeResponse',
      'GetItemLocationDetail' => 'Opsuite\\Inventory\\GetItemLocationDetail',
      'GetItemLocationDetailResponse' => 'Opsuite\\Inventory\\GetItemLocationDetailResponse',
      'GetItemLocationDetailForCashier' => 'Opsuite\\Inventory\\GetItemLocationDetailForCashier',
      'GetItemLocationDetailForCashierResponse' => 'Opsuite\\Inventory\\GetItemLocationDetailForCashierResponse',
      'GetItemsAtLocation' => 'Opsuite\\Inventory\\GetItemsAtLocation',
      'GetItemsAtLocationResponse' => 'Opsuite\\Inventory\\GetItemsAtLocationResponse',
      'GetWebItemsAtLocation' => 'Opsuite\\Inventory\\GetWebItemsAtLocation',
      'GetWebItemsAtLocationResponse' => 'Opsuite\\Inventory\\GetWebItemsAtLocationResponse',
      'GetQuantityOfItemsAtLocation' => 'Opsuite\\Inventory\\GetQuantityOfItemsAtLocation',
      'GetQuantityOfItemsAtLocationResponse' => 'Opsuite\\Inventory\\GetQuantityOfItemsAtLocationResponse',
      'GetQuantityOfWebItemsAtLocation' => 'Opsuite\\Inventory\\GetQuantityOfWebItemsAtLocation',
      'GetQuantityOfWebItemsAtLocationResponse' => 'Opsuite\\Inventory\\GetQuantityOfWebItemsAtLocationResponse',
      'InsertDepartment' => 'Opsuite\\Inventory\\InsertDepartment',
      'InsertDepartmentResponse' => 'Opsuite\\Inventory\\InsertDepartmentResponse',
      'InsertCategory' => 'Opsuite\\Inventory\\InsertCategory',
      'InsertCategoryResponse' => 'Opsuite\\Inventory\\InsertCategoryResponse',
      'SubmitItemsToMatrix' => 'Opsuite\\Inventory\\SubmitItemsToMatrix',
      'SubmitItemsToMatrixResponse' => 'Opsuite\\Inventory\\SubmitItemsToMatrixResponse',
      'GetMatrixMasters' => 'Opsuite\\Inventory\\GetMatrixMasters',
      'GetMatrixMastersResponse' => 'Opsuite\\Inventory\\GetMatrixMastersResponse',
      'GetMatrixMastersBySku' => 'Opsuite\\Inventory\\GetMatrixMastersBySku',
      'GetMatrixMastersBySkuResponse' => 'Opsuite\\Inventory\\GetMatrixMastersBySkuResponse',
      'SubmitMatrixMasters' => 'Opsuite\\Inventory\\SubmitMatrixMasters',
      'SubmitMatrixMastersResponse' => 'Opsuite\\Inventory\\SubmitMatrixMastersResponse',
      'SubmitVendors' => 'Opsuite\\Inventory\\SubmitVendors',
      'SubmitVendorsResponse' => 'Opsuite\\Inventory\\SubmitVendorsResponse',
      'CreateBounceBackVoucher' => 'Opsuite\\Inventory\\CreateBounceBackVoucher',
      'CreateBounceBackVoucherResponse' => 'Opsuite\\Inventory\\CreateBounceBackVoucherResponse',
      'GetBounceBackVoucher' => 'Opsuite\\Inventory\\GetBounceBackVoucher',
      'GetBounceBackVoucherResponse' => 'Opsuite\\Inventory\\GetBounceBackVoucherResponse',
      'RedeemBounceBackVoucher' => 'Opsuite\\Inventory\\RedeemBounceBackVoucher',
      'RedeemBounceBackVoucherResponse' => 'Opsuite\\Inventory\\RedeemBounceBackVoucherResponse',
      'GetDiscountCoupon' => 'Opsuite\\Inventory\\GetDiscountCoupon',
      'GetDiscountCouponResponse' => 'Opsuite\\Inventory\\GetDiscountCouponResponse',
      'RedeemDiscountCoupon' => 'Opsuite\\Inventory\\RedeemDiscountCoupon',
      'RedeemDiscountCouponResponse' => 'Opsuite\\Inventory\\RedeemDiscountCouponResponse',
      'GetPromotionCoupon' => 'Opsuite\\Inventory\\GetPromotionCoupon',
      'GetPromotionCouponResponse' => 'Opsuite\\Inventory\\GetPromotionCouponResponse',
      'RedeemPromotionCoupon' => 'Opsuite\\Inventory\\RedeemPromotionCoupon',
      'RedeemPromotionCouponResponse' => 'Opsuite\\Inventory\\RedeemPromotionCouponResponse',
      'GetItemMastersByLastUpdatedPaged' => 'Opsuite\\Inventory\\GetItemMastersByLastUpdatedPaged',
      'GetItemMastersByLastUpdatedPagedResponse' => 'Opsuite\\Inventory\\GetItemMastersByLastUpdatedPagedResponse',
      'GetItemsAtLocationPaged' => 'Opsuite\\Inventory\\GetItemsAtLocationPaged',
      'GetItemsAtLocationPagedResponse' => 'Opsuite\\Inventory\\GetItemsAtLocationPagedResponse',
      'GetProductPackagesByItemIds' => 'Opsuite\\Inventory\\GetProductPackagesByItemIds',
      'GetProductPackagesByItemIdsResponse' => 'Opsuite\\Inventory\\GetProductPackagesByItemIdsResponse',
      'GetProductPackagesByProductCodes' => 'Opsuite\\Inventory\\GetProductPackagesByProductCodes',
      'GetProductPackagesByProductCodesResponse' => 'Opsuite\\Inventory\\GetProductPackagesByProductCodesResponse',
      'GetManualInventoryAdjustments' => 'Opsuite\\Inventory\\GetManualInventoryAdjustments',
      'GetManualInventoryAdjustmentsResponse' => 'Opsuite\\Inventory\\GetManualInventoryAdjustmentsResponse',
      'SubmitInventoryAdjustments' => 'Opsuite\\Inventory\\SubmitInventoryAdjustments',
      'SubmitInventoryAdjustmentsResponse' => 'Opsuite\\Inventory\\SubmitInventoryAdjustmentsResponse',
      'GetItemSkusWithWebContent' => 'Opsuite\\Inventory\\GetItemSkusWithWebContent',
      'GetItemSkusWithWebContentResponse' => 'Opsuite\\Inventory\\GetItemSkusWithWebContentResponse',
      'DoesItemHaveWebContentBySku' => 'Opsuite\\Inventory\\DoesItemHaveWebContentBySku',
      'DoesItemHaveWebContentBySkuResponse' => 'Opsuite\\Inventory\\DoesItemHaveWebContentBySkuResponse',
      'DoesItemHaveWebContentById' => 'Opsuite\\Inventory\\DoesItemHaveWebContentById',
      'DoesItemHaveWebContentByIdResponse' => 'Opsuite\\Inventory\\DoesItemHaveWebContentByIdResponse',
      'GetItemWithWebContentBySku' => 'Opsuite\\Inventory\\GetItemWithWebContentBySku',
      'GetItemWithWebContentBySkuResponse' => 'Opsuite\\Inventory\\GetItemWithWebContentBySkuResponse',
      'GetItemWithWebContentById' => 'Opsuite\\Inventory\\GetItemWithWebContentById',
      'GetItemWithWebContentByIdResponse' => 'Opsuite\\Inventory\\GetItemWithWebContentByIdResponse',
      'GetItemWebContentBySku' => 'Opsuite\\Inventory\\GetItemWebContentBySku',
      'GetItemWebContentBySkuResponse' => 'Opsuite\\Inventory\\GetItemWebContentBySkuResponse',
      'GetItemWebContentById' => 'Opsuite\\Inventory\\GetItemWebContentById',
      'GetItemWebContentByIdResponse' => 'Opsuite\\Inventory\\GetItemWebContentByIdResponse',
      'GetItemWebLinksBySku' => 'Opsuite\\Inventory\\GetItemWebLinksBySku',
      'GetItemWebLinksBySkuResponse' => 'Opsuite\\Inventory\\GetItemWebLinksBySkuResponse',
      'GetItemWebLinksById' => 'Opsuite\\Inventory\\GetItemWebLinksById',
      'GetItemWebLinksByIdResponse' => 'Opsuite\\Inventory\\GetItemWebLinksByIdResponse',
      'GetItemMastersWithWebContentByLastUpdatedPaged' => 'Opsuite\\Inventory\\GetItemMastersWithWebContentByLastUpdatedPaged',
      'GetItemMastersWithWebContentByLastUpdatedPagedResponse' => 'Opsuite\\Inventory\\GetItemMastersWithWebContentByLastUpdatedPagedResponse',
      'GetSpecialOffersForSku' => 'Opsuite\\Inventory\\GetSpecialOffersForSku',
      'GetSpecialOffersForSkuResponse' => 'Opsuite\\Inventory\\GetSpecialOffersForSkuResponse',
      'GetSpecialOffersForItemId' => 'Opsuite\\Inventory\\GetSpecialOffersForItemId',
      'GetSpecialOffersForItemIdResponse' => 'Opsuite\\Inventory\\GetSpecialOffersForItemIdResponse',
      'GetItemsWithSpecialOffersByLastUpdatedPaged' => 'Opsuite\\Inventory\\GetItemsWithSpecialOffersByLastUpdatedPaged',
      'GetItemsWithSpecialOffersByLastUpdatedPagedResponse' => 'Opsuite\\Inventory\\GetItemsWithSpecialOffersByLastUpdatedPagedResponse',
      'GetItemSkusWithSpecialOffersByLastUpdatedPaged' => 'Opsuite\\Inventory\\GetItemSkusWithSpecialOffersByLastUpdatedPaged',
      'GetItemSkusWithSpecialOffersByLastUpdatedPagedResponse' => 'Opsuite\\Inventory\\GetItemSkusWithSpecialOffersByLastUpdatedPagedResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/InventoryService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetItemMasters $parameters
     * @return GetItemMastersResponse
     */
    public function GetItemMasters(GetItemMasters $parameters)
    {
      return $this->__soapCall('GetItemMasters', array($parameters));
    }

    /**
     * @param GetWebItemMasters $parameters
     * @return GetWebItemMastersResponse
     */
    public function GetWebItemMasters(GetWebItemMasters $parameters)
    {
      return $this->__soapCall('GetWebItemMasters', array($parameters));
    }

    /**
     * @param GetItemMastersByLastUpdated $parameters
     * @return GetItemMastersByLastUpdatedResponse
     */
    public function GetItemMastersByLastUpdated(GetItemMastersByLastUpdated $parameters)
    {
      return $this->__soapCall('GetItemMastersByLastUpdated', array($parameters));
    }

    /**
     * @param GetItemMaster $parameters
     * @return GetItemMasterResponse
     */
    public function GetItemMaster(GetItemMaster $parameters)
    {
      return $this->__soapCall('GetItemMaster', array($parameters));
    }

    /**
     * @param GetItemMastersBySkus $parameters
     * @return GetItemMastersBySkusResponse
     */
    public function GetItemMastersBySkus(GetItemMastersBySkus $parameters)
    {
      return $this->__soapCall('GetItemMastersBySkus', array($parameters));
    }

    /**
     * @param GetItemMasterAttributesBySkus $parameters
     * @return GetItemMasterAttributesBySkusResponse
     */
    public function GetItemMasterAttributesBySkus(GetItemMasterAttributesBySkus $parameters)
    {
      return $this->__soapCall('GetItemMasterAttributesBySkus', array($parameters));
    }

    /**
     * @param SubmitItemMasters $parameters
     * @return SubmitItemMastersResponse
     */
    public function SubmitItemMasters(SubmitItemMasters $parameters)
    {
      return $this->__soapCall('SubmitItemMasters', array($parameters));
    }

    /**
     * @param SubmitItemLocationDetails $parameters
     * @return SubmitItemLocationDetailsResponse
     */
    public function SubmitItemLocationDetails(SubmitItemLocationDetails $parameters)
    {
      return $this->__soapCall('SubmitItemLocationDetails', array($parameters));
    }

    /**
     * @param GetCategories $parameters
     * @return GetCategoriesResponse
     */
    public function GetCategories(GetCategories $parameters)
    {
      return $this->__soapCall('GetCategories', array($parameters));
    }

    /**
     * @param GetCategoryNames $parameters
     * @return GetCategoryNamesResponse
     */
    public function GetCategoryNames(GetCategoryNames $parameters)
    {
      return $this->__soapCall('GetCategoryNames', array($parameters));
    }

    /**
     * @param GetDepartments $parameters
     * @return GetDepartmentsResponse
     */
    public function GetDepartments(GetDepartments $parameters)
    {
      return $this->__soapCall('GetDepartments', array($parameters));
    }

    /**
     * @param GetDepartmentNames $parameters
     * @return GetDepartmentNamesResponse
     */
    public function GetDepartmentNames(GetDepartmentNames $parameters)
    {
      return $this->__soapCall('GetDepartmentNames', array($parameters));
    }

    /**
     * @param GetUom $parameters
     * @return GetUomResponse
     */
    public function GetUom(GetUom $parameters)
    {
      return $this->__soapCall('GetUom', array($parameters));
    }

    /**
     * @param GetBarCodeFormats $parameters
     * @return GetBarCodeFormatsResponse
     */
    public function GetBarCodeFormats(GetBarCodeFormats $parameters)
    {
      return $this->__soapCall('GetBarCodeFormats', array($parameters));
    }

    /**
     * @param GetItemTypes $parameters
     * @return GetItemTypesResponse
     */
    public function GetItemTypes(GetItemTypes $parameters)
    {
      return $this->__soapCall('GetItemTypes', array($parameters));
    }

    /**
     * @param GetVendors $parameters
     * @return GetVendorsResponse
     */
    public function GetVendors(GetVendors $parameters)
    {
      return $this->__soapCall('GetVendors', array($parameters));
    }

    /**
     * @param GetVendorByVendorCode $parameters
     * @return GetVendorByVendorCodeResponse
     */
    public function GetVendorByVendorCode(GetVendorByVendorCode $parameters)
    {
      return $this->__soapCall('GetVendorByVendorCode', array($parameters));
    }

    /**
     * @param GetItemLocationDetail $parameters
     * @return GetItemLocationDetailResponse
     */
    public function GetItemLocationDetail(GetItemLocationDetail $parameters)
    {
      return $this->__soapCall('GetItemLocationDetail', array($parameters));
    }

    /**
     * @param GetItemLocationDetailForCashier $parameters
     * @return GetItemLocationDetailForCashierResponse
     */
    public function GetItemLocationDetailForCashier(GetItemLocationDetailForCashier $parameters)
    {
      return $this->__soapCall('GetItemLocationDetailForCashier', array($parameters));
    }

    /**
     * @param GetItemsAtLocation $parameters
     * @return GetItemsAtLocationResponse
     */
    public function GetItemsAtLocation(GetItemsAtLocation $parameters)
    {
      return $this->__soapCall('GetItemsAtLocation', array($parameters));
    }

    /**
     * @param GetWebItemsAtLocation $parameters
     * @return GetWebItemsAtLocationResponse
     */
    public function GetWebItemsAtLocation(GetWebItemsAtLocation $parameters)
    {
      return $this->__soapCall('GetWebItemsAtLocation', array($parameters));
    }

    /**
     * @param GetQuantityOfItemsAtLocation $parameters
     * @return GetQuantityOfItemsAtLocationResponse
     */
    public function GetQuantityOfItemsAtLocation(GetQuantityOfItemsAtLocation $parameters)
    {
      return $this->__soapCall('GetQuantityOfItemsAtLocation', array($parameters));
    }

    /**
     * @param GetQuantityOfWebItemsAtLocation $parameters
     * @return GetQuantityOfWebItemsAtLocationResponse
     */
    public function GetQuantityOfWebItemsAtLocation(GetQuantityOfWebItemsAtLocation $parameters)
    {
      return $this->__soapCall('GetQuantityOfWebItemsAtLocation', array($parameters));
    }

    /**
     * @param InsertDepartment $parameters
     * @return InsertDepartmentResponse
     */
    public function InsertDepartment(InsertDepartment $parameters)
    {
      return $this->__soapCall('InsertDepartment', array($parameters));
    }

    /**
     * @param InsertCategory $parameters
     * @return InsertCategoryResponse
     */
    public function InsertCategory(InsertCategory $parameters)
    {
      return $this->__soapCall('InsertCategory', array($parameters));
    }

    /**
     * @param SubmitItemsToMatrix $parameters
     * @return SubmitItemsToMatrixResponse
     */
    public function SubmitItemsToMatrix(SubmitItemsToMatrix $parameters)
    {
      return $this->__soapCall('SubmitItemsToMatrix', array($parameters));
    }

    /**
     * @param GetMatrixMasters $parameters
     * @return GetMatrixMastersResponse
     */
    public function GetMatrixMasters(GetMatrixMasters $parameters)
    {
      return $this->__soapCall('GetMatrixMasters', array($parameters));
    }

    /**
     * @param GetMatrixMastersBySku $parameters
     * @return GetMatrixMastersBySkuResponse
     */
    public function GetMatrixMastersBySku(GetMatrixMastersBySku $parameters)
    {
      return $this->__soapCall('GetMatrixMastersBySku', array($parameters));
    }

    /**
     * @param SubmitMatrixMasters $parameters
     * @return SubmitMatrixMastersResponse
     */
    public function SubmitMatrixMasters(SubmitMatrixMasters $parameters)
    {
      return $this->__soapCall('SubmitMatrixMasters', array($parameters));
    }

    /**
     * @param SubmitVendors $parameters
     * @return SubmitVendorsResponse
     */
    public function SubmitVendors(SubmitVendors $parameters)
    {
      return $this->__soapCall('SubmitVendors', array($parameters));
    }

    /**
     * @param CreateBounceBackVoucher $parameters
     * @return CreateBounceBackVoucherResponse
     */
    public function CreateBounceBackVoucher(CreateBounceBackVoucher $parameters)
    {
      return $this->__soapCall('CreateBounceBackVoucher', array($parameters));
    }

    /**
     * @param GetBounceBackVoucher $parameters
     * @return GetBounceBackVoucherResponse
     */
    public function GetBounceBackVoucher(GetBounceBackVoucher $parameters)
    {
      return $this->__soapCall('GetBounceBackVoucher', array($parameters));
    }

    /**
     * @param RedeemBounceBackVoucher $parameters
     * @return RedeemBounceBackVoucherResponse
     */
    public function RedeemBounceBackVoucher(RedeemBounceBackVoucher $parameters)
    {
      return $this->__soapCall('RedeemBounceBackVoucher', array($parameters));
    }

    /**
     * @param GetDiscountCoupon $parameters
     * @return GetDiscountCouponResponse
     */
    public function GetDiscountCoupon(GetDiscountCoupon $parameters)
    {
      return $this->__soapCall('GetDiscountCoupon', array($parameters));
    }

    /**
     * @param RedeemDiscountCoupon $parameters
     * @return RedeemDiscountCouponResponse
     */
    public function RedeemDiscountCoupon(RedeemDiscountCoupon $parameters)
    {
      return $this->__soapCall('RedeemDiscountCoupon', array($parameters));
    }

    /**
     * @param GetPromotionCoupon $parameters
     * @return GetPromotionCouponResponse
     */
    public function GetPromotionCoupon(GetPromotionCoupon $parameters)
    {
      return $this->__soapCall('GetPromotionCoupon', array($parameters));
    }

    /**
     * @param RedeemPromotionCoupon $parameters
     * @return RedeemPromotionCouponResponse
     */
    public function RedeemPromotionCoupon(RedeemPromotionCoupon $parameters)
    {
      return $this->__soapCall('RedeemPromotionCoupon', array($parameters));
    }

    /**
     * @param GetItemMastersByLastUpdatedPaged $parameters
     * @return GetItemMastersByLastUpdatedPagedResponse
     */
    public function GetItemMastersByLastUpdatedPaged(GetItemMastersByLastUpdatedPaged $parameters)
    {
      return $this->__soapCall('GetItemMastersByLastUpdatedPaged', array($parameters));
    }

    /**
     * @param GetItemsAtLocationPaged $parameters
     * @return GetItemsAtLocationPagedResponse
     */
    public function GetItemsAtLocationPaged(GetItemsAtLocationPaged $parameters)
    {
      return $this->__soapCall('GetItemsAtLocationPaged', array($parameters));
    }

    /**
     * @param GetProductPackagesByItemIds $parameters
     * @return GetProductPackagesByItemIdsResponse
     */
    public function GetProductPackagesByItemIds(GetProductPackagesByItemIds $parameters)
    {
      return $this->__soapCall('GetProductPackagesByItemIds', array($parameters));
    }

    /**
     * @param GetProductPackagesByProductCodes $parameters
     * @return GetProductPackagesByProductCodesResponse
     */
    public function GetProductPackagesByProductCodes(GetProductPackagesByProductCodes $parameters)
    {
      return $this->__soapCall('GetProductPackagesByProductCodes', array($parameters));
    }

    /**
     * @param GetManualInventoryAdjustments $parameters
     * @return GetManualInventoryAdjustmentsResponse
     */
    public function GetManualInventoryAdjustments(GetManualInventoryAdjustments $parameters)
    {
      return $this->__soapCall('GetManualInventoryAdjustments', array($parameters));
    }

    /**
     * @param SubmitInventoryAdjustments $parameters
     * @return SubmitInventoryAdjustmentsResponse
     */
    public function SubmitInventoryAdjustments(SubmitInventoryAdjustments $parameters)
    {
      return $this->__soapCall('SubmitInventoryAdjustments', array($parameters));
    }

    /**
     * @param GetItemSkusWithWebContent $parameters
     * @return GetItemSkusWithWebContentResponse
     */
    public function GetItemSkusWithWebContent(GetItemSkusWithWebContent $parameters)
    {
      return $this->__soapCall('GetItemSkusWithWebContent', array($parameters));
    }

    /**
     * @param DoesItemHaveWebContentBySku $parameters
     * @return DoesItemHaveWebContentBySkuResponse
     */
    public function DoesItemHaveWebContentBySku(DoesItemHaveWebContentBySku $parameters)
    {
      return $this->__soapCall('DoesItemHaveWebContentBySku', array($parameters));
    }

    /**
     * @param DoesItemHaveWebContentById $parameters
     * @return DoesItemHaveWebContentByIdResponse
     */
    public function DoesItemHaveWebContentById(DoesItemHaveWebContentById $parameters)
    {
      return $this->__soapCall('DoesItemHaveWebContentById', array($parameters));
    }

    /**
     * @param GetItemWithWebContentBySku $parameters
     * @return GetItemWithWebContentBySkuResponse
     */
    public function GetItemWithWebContentBySku(GetItemWithWebContentBySku $parameters)
    {
      return $this->__soapCall('GetItemWithWebContentBySku', array($parameters));
    }

    /**
     * @param GetItemWithWebContentById $parameters
     * @return GetItemWithWebContentByIdResponse
     */
    public function GetItemWithWebContentById(GetItemWithWebContentById $parameters)
    {
      return $this->__soapCall('GetItemWithWebContentById', array($parameters));
    }

    /**
     * @param GetItemWebContentBySku $parameters
     * @return GetItemWebContentBySkuResponse
     */
    public function GetItemWebContentBySku(GetItemWebContentBySku $parameters)
    {
      return $this->__soapCall('GetItemWebContentBySku', array($parameters));
    }

    /**
     * @param GetItemWebContentById $parameters
     * @return GetItemWebContentByIdResponse
     */
    public function GetItemWebContentById(GetItemWebContentById $parameters)
    {
      return $this->__soapCall('GetItemWebContentById', array($parameters));
    }

    /**
     * @param GetItemWebLinksBySku $parameters
     * @return GetItemWebLinksBySkuResponse
     */
    public function GetItemWebLinksBySku(GetItemWebLinksBySku $parameters)
    {
      return $this->__soapCall('GetItemWebLinksBySku', array($parameters));
    }

    /**
     * @param GetItemWebLinksById $parameters
     * @return GetItemWebLinksByIdResponse
     */
    public function GetItemWebLinksById(GetItemWebLinksById $parameters)
    {
      return $this->__soapCall('GetItemWebLinksById', array($parameters));
    }

    /**
     * @param GetItemMastersWithWebContentByLastUpdatedPaged $parameters
     * @return GetItemMastersWithWebContentByLastUpdatedPagedResponse
     */
    public function GetItemMastersWithWebContentByLastUpdatedPaged(GetItemMastersWithWebContentByLastUpdatedPaged $parameters)
    {
      return $this->__soapCall('GetItemMastersWithWebContentByLastUpdatedPaged', array($parameters));
    }

    /**
     * @param GetSpecialOffersForSku $parameters
     * @return GetSpecialOffersForSkuResponse
     */
    public function GetSpecialOffersForSku(GetSpecialOffersForSku $parameters)
    {
      return $this->__soapCall('GetSpecialOffersForSku', array($parameters));
    }

    /**
     * @param GetSpecialOffersForItemId $parameters
     * @return GetSpecialOffersForItemIdResponse
     */
    public function GetSpecialOffersForItemId(GetSpecialOffersForItemId $parameters)
    {
      return $this->__soapCall('GetSpecialOffersForItemId', array($parameters));
    }

    /**
     * @param GetItemsWithSpecialOffersByLastUpdatedPaged $parameters
     * @return GetItemsWithSpecialOffersByLastUpdatedPagedResponse
     */
    public function GetItemsWithSpecialOffersByLastUpdatedPaged(GetItemsWithSpecialOffersByLastUpdatedPaged $parameters)
    {
      return $this->__soapCall('GetItemsWithSpecialOffersByLastUpdatedPaged', array($parameters));
    }

    /**
     * @param GetItemSkusWithSpecialOffersByLastUpdatedPaged $parameters
     * @return GetItemSkusWithSpecialOffersByLastUpdatedPagedResponse
     */
    public function GetItemSkusWithSpecialOffersByLastUpdatedPaged(GetItemSkusWithSpecialOffersByLastUpdatedPaged $parameters)
    {
      return $this->__soapCall('GetItemSkusWithSpecialOffersByLastUpdatedPaged', array($parameters));
    }

}
