<?php

namespace Opsuite\Inventory;

class GetWebItemsAtLocation
{

    /**
     * @var int $locatonId
     */
    protected $locatonId = null;

    /**
     * @var \DateTime $updatedAfterDateTime
     */
    protected $updatedAfterDateTime = null;

    /**
     * @param int $locatonId
     * @param \DateTime $updatedAfterDateTime
     */
    public function __construct($locatonId, \DateTime $updatedAfterDateTime)
    {
      $this->locatonId = $locatonId;
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
    }

    /**
     * @return int
     */
    public function getLocatonId()
    {
      return $this->locatonId;
    }

    /**
     * @param int $locatonId
     * @return \Opsuite\Inventory\GetWebItemsAtLocation
     */
    public function setLocatonId($locatonId)
    {
      $this->locatonId = $locatonId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAfterDateTime()
    {
      if ($this->updatedAfterDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->updatedAfterDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $updatedAfterDateTime
     * @return \Opsuite\Inventory\GetWebItemsAtLocation
     */
    public function setUpdatedAfterDateTime(\DateTime $updatedAfterDateTime)
    {
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
      return $this;
    }

}
