<?php

namespace Opsuite\Inventory;

class GetSpecialOffersForSku
{

    /**
     * @var string $sku
     */
    protected $sku = null;

    /**
     * @var string $locationCode
     */
    protected $locationCode = null;

    /**
     * @var boolean $showInactive
     */
    protected $showInactive = null;

    /**
     * @var ArrayOfstring $ignoredPromos
     */
    protected $ignoredPromos = null;

    /**
     * @param string $sku
     * @param string $locationCode
     * @param boolean $showInactive
     * @param ArrayOfstring $ignoredPromos
     */
    public function __construct($sku, $locationCode, $showInactive, $ignoredPromos)
    {
      $this->sku = $sku;
      $this->locationCode = $locationCode;
      $this->showInactive = $showInactive;
      $this->ignoredPromos = $ignoredPromos;
    }

    /**
     * @return string
     */
    public function getSku()
    {
      return $this->sku;
    }

    /**
     * @param string $sku
     * @return \Opsuite\Inventory\GetSpecialOffersForSku
     */
    public function setSku($sku)
    {
      $this->sku = $sku;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationCode()
    {
      return $this->locationCode;
    }

    /**
     * @param string $locationCode
     * @return \Opsuite\Inventory\GetSpecialOffersForSku
     */
    public function setLocationCode($locationCode)
    {
      $this->locationCode = $locationCode;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getShowInactive()
    {
      return $this->showInactive;
    }

    /**
     * @param boolean $showInactive
     * @return \Opsuite\Inventory\GetSpecialOffersForSku
     */
    public function setShowInactive($showInactive)
    {
      $this->showInactive = $showInactive;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getIgnoredPromos()
    {
      return $this->ignoredPromos;
    }

    /**
     * @param ArrayOfstring $ignoredPromos
     * @return \Opsuite\Inventory\GetSpecialOffersForSku
     */
    public function setIgnoredPromos($ignoredPromos)
    {
      $this->ignoredPromos = $ignoredPromos;
      return $this;
    }

}
